/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.springframework.cloud.stream.binder.AbstractBinder;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.DefaultBinding;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.binder.kafka.provisioning.KafkaTopicProvisioner;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBinderUtils;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBindingInformationCatalogue;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsRegistry;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsConsumerProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsExtendedBindingProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsProducerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.Lifecycle;
import org.springframework.kafka.config.StreamsBuilderFactoryBean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.StringUtils;

public class GlobalKTableBinder
extends AbstractBinder<GlobalKTable<Object, Object>, ExtendedConsumerProperties<KafkaStreamsConsumerProperties>, ExtendedProducerProperties<KafkaStreamsProducerProperties>>
implements ExtendedPropertiesBinder<GlobalKTable<Object, Object>, KafkaStreamsConsumerProperties, KafkaStreamsProducerProperties> {
    private final KafkaStreamsBinderConfigurationProperties binderConfigurationProperties;
    private final KafkaTopicProvisioner kafkaTopicProvisioner;
    private final KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue;
    private KafkaStreamsExtendedBindingProperties kafkaStreamsExtendedBindingProperties = new KafkaStreamsExtendedBindingProperties();
    private final KafkaStreamsRegistry kafkaStreamsRegistry;

    public GlobalKTableBinder(KafkaStreamsBinderConfigurationProperties binderConfigurationProperties, KafkaTopicProvisioner kafkaTopicProvisioner, KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue, KafkaStreamsRegistry kafkaStreamsRegistry) {
        this.binderConfigurationProperties = binderConfigurationProperties;
        this.kafkaTopicProvisioner = kafkaTopicProvisioner;
        this.kafkaStreamsBindingInformationCatalogue = kafkaStreamsBindingInformationCatalogue;
        this.kafkaStreamsRegistry = kafkaStreamsRegistry;
    }

    protected Binding<GlobalKTable<Object, Object>> doBindConsumer(String name, String group, GlobalKTable<Object, Object> inputTarget, ExtendedConsumerProperties<KafkaStreamsConsumerProperties> properties) {
        if (!StringUtils.hasText((String)group)) {
            group = ((KafkaStreamsConsumerProperties)((Object)properties.getExtension())).getApplicationId();
        }
        RetryTemplate retryTemplate = this.buildRetryTemplate((ConsumerProperties)properties);
        String bindingName = this.kafkaStreamsBindingInformationCatalogue.bindingNamePerTarget(inputTarget);
        final StreamsBuilderFactoryBean streamsBuilderFactoryBean = this.kafkaStreamsBindingInformationCatalogue.getStreamsBuilderFactoryBeanPerBinding().get(bindingName);
        KafkaStreamsBinderUtils.prepareConsumerBinding(name, group, (ApplicationContext)this.getApplicationContext(), this.kafkaTopicProvisioner, this.binderConfigurationProperties, properties, retryTemplate, this.getBeanFactory(), this.kafkaStreamsBindingInformationCatalogue.bindingNamePerTarget(inputTarget), this.kafkaStreamsBindingInformationCatalogue, streamsBuilderFactoryBean);
        return new DefaultBinding<GlobalKTable<Object, Object>>(bindingName, group, inputTarget, (Lifecycle)streamsBuilderFactoryBean){

            public boolean isInput() {
                return true;
            }

            public synchronized void start() {
                if (!streamsBuilderFactoryBean.isRunning()) {
                    super.start();
                    GlobalKTableBinder.this.kafkaStreamsRegistry.registerKafkaStreams(streamsBuilderFactoryBean);
                }
            }

            public synchronized void stop() {
                if (streamsBuilderFactoryBean.isRunning()) {
                    KafkaStreams kafkaStreams = streamsBuilderFactoryBean.getKafkaStreams();
                    super.stop();
                    GlobalKTableBinder.this.kafkaStreamsRegistry.unregisterKafkaStreams(kafkaStreams);
                    KafkaStreamsBinderUtils.closeDlqProducerFactories(GlobalKTableBinder.this.kafkaStreamsBindingInformationCatalogue, streamsBuilderFactoryBean);
                }
            }
        };
    }

    protected Binding<GlobalKTable<Object, Object>> doBindProducer(String name, GlobalKTable<Object, Object> outboundBindTarget, ExtendedProducerProperties<KafkaStreamsProducerProperties> properties) {
        throw new UnsupportedOperationException("No producer level binding is allowed for GlobalKTable");
    }

    public KafkaStreamsConsumerProperties getExtendedConsumerProperties(String channelName) {
        return (KafkaStreamsConsumerProperties)((Object)this.kafkaStreamsExtendedBindingProperties.getExtendedConsumerProperties(channelName));
    }

    public KafkaStreamsProducerProperties getExtendedProducerProperties(String channelName) {
        throw new UnsupportedOperationException("No producer binding is allowed and therefore no properties");
    }

    public String getDefaultsPrefix() {
        return this.kafkaStreamsExtendedBindingProperties.getDefaultsPrefix();
    }

    public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
        return this.kafkaStreamsExtendedBindingProperties.getExtendedPropertiesEntryClass();
    }

    public void setKafkaStreamsExtendedBindingProperties(KafkaStreamsExtendedBindingProperties kafkaStreamsExtendedBindingProperties) {
        this.kafkaStreamsExtendedBindingProperties = kafkaStreamsExtendedBindingProperties;
    }
}

