/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.kafka.streams.EncodingDecodingBindAdviceHandler;
import org.springframework.cloud.stream.binding.AbstractBindingTargetFactory;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.util.Assert;

public class GlobalKTableBoundElementFactory
extends AbstractBindingTargetFactory<GlobalKTable> {
    private final BindingServiceProperties bindingServiceProperties;
    private final EncodingDecodingBindAdviceHandler encodingDecodingBindAdviceHandler;

    GlobalKTableBoundElementFactory(BindingServiceProperties bindingServiceProperties, EncodingDecodingBindAdviceHandler encodingDecodingBindAdviceHandler) {
        super(GlobalKTable.class);
        this.bindingServiceProperties = bindingServiceProperties;
        this.encodingDecodingBindAdviceHandler = encodingDecodingBindAdviceHandler;
    }

    public GlobalKTable createInput(String name) {
        BindingProperties bindingProperties = this.bindingServiceProperties.getBindingProperties(name);
        ConsumerProperties consumerProperties = bindingProperties.getConsumer();
        if (consumerProperties == null) {
            consumerProperties = this.bindingServiceProperties.getConsumerProperties(name);
            consumerProperties.setUseNativeDecoding(true);
        } else if (!this.encodingDecodingBindAdviceHandler.isDecodingSettingProvided()) {
            consumerProperties.setUseNativeDecoding(true);
        }
        consumerProperties.setMultiplex(true);
        GlobalKTableWrapperHandler wrapper = new GlobalKTableWrapperHandler();
        ProxyFactory proxyFactory = new ProxyFactory(new Class[]{GlobalKTableWrapper.class, GlobalKTable.class});
        proxyFactory.addAdvice((Advice)wrapper);
        return (GlobalKTable)proxyFactory.getProxy();
    }

    public GlobalKTable createOutput(String name) {
        throw new UnsupportedOperationException("Outbound operations are not allowed on target type GlobalKTable");
    }

    private static class GlobalKTableWrapperHandler
    implements GlobalKTableWrapper,
    MethodInterceptor {
        private GlobalKTable<Object, Object> delegate;

        private GlobalKTableWrapperHandler() {
        }

        @Override
        public void wrap(GlobalKTable<Object, Object> delegate) {
            Assert.notNull(delegate, (String)"delegate cannot be null");
            if (this.delegate == null) {
                this.delegate = delegate;
            }
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            if (methodInvocation.getMethod().getDeclaringClass().equals(GlobalKTable.class)) {
                Assert.notNull(this.delegate, (String)("Trying to prepareConsumerBinding " + methodInvocation.getMethod() + "  but no delegate has been set."));
                return methodInvocation.getMethod().invoke(this.delegate, methodInvocation.getArguments());
            }
            if (methodInvocation.getMethod().getDeclaringClass().equals(GlobalKTableWrapper.class)) {
                return methodInvocation.getMethod().invoke((Object)this, methodInvocation.getArguments());
            }
            throw new IllegalStateException("Only GlobalKTable method invocations are permitted");
        }
    }

    public static interface GlobalKTableWrapper {
        public void wrap(GlobalKTable<Object, Object> var1);
    }
}

