/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.streams.KafkaStreams;
import org.springframework.kafka.config.StreamsBuilderFactoryBean;

public class KafkaStreamsRegistry {
    private Map<KafkaStreams, StreamsBuilderFactoryBean> streamsBuilderFactoryBeanMap = new HashMap<KafkaStreams, StreamsBuilderFactoryBean>();
    private final Set<KafkaStreams> kafkaStreams = new HashSet<KafkaStreams>();

    Set<KafkaStreams> getKafkaStreams() {
        return this.kafkaStreams;
    }

    void registerKafkaStreams(StreamsBuilderFactoryBean streamsBuilderFactoryBean) {
        KafkaStreams kafkaStreams = streamsBuilderFactoryBean.getKafkaStreams();
        this.kafkaStreams.add(kafkaStreams);
        this.streamsBuilderFactoryBeanMap.put(kafkaStreams, streamsBuilderFactoryBean);
    }

    StreamsBuilderFactoryBean streamBuilderFactoryBean(KafkaStreams kafkaStreams) {
        return this.streamsBuilderFactoryBeanMap.get(kafkaStreams);
    }

    public StreamsBuilderFactoryBean streamsBuilderFactoryBean(String applicationId) {
        Optional<StreamsBuilderFactoryBean> first = this.streamsBuilderFactoryBeanMap.values().stream().filter(streamsBuilderFactoryBean -> streamsBuilderFactoryBean.getStreamsConfiguration().getProperty("application.id").equals(applicationId)).findFirst();
        return first.orElse(null);
    }

    public List<StreamsBuilderFactoryBean> streamsBuilderFactoryBeans() {
        return new ArrayList<StreamsBuilderFactoryBean>(this.streamsBuilderFactoryBeanMap.values());
    }
}

