/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsConsumerProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsProducerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.kafka.support.serializer.JsonSerde;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class KeyValueSerdeResolver
implements ApplicationContextAware {
    private static final Log LOG = LogFactory.getLog(KeyValueSerdeResolver.class);
    private final Map<String, Object> streamConfigGlobalProperties;
    private final KafkaStreamsBinderConfigurationProperties binderConfigurationProperties;
    private ConfigurableApplicationContext context;

    KeyValueSerdeResolver(Map<String, Object> streamConfigGlobalProperties, KafkaStreamsBinderConfigurationProperties binderConfigurationProperties) {
        this.streamConfigGlobalProperties = streamConfigGlobalProperties;
        this.binderConfigurationProperties = binderConfigurationProperties;
    }

    public Serde<?> getInboundKeySerde(KafkaStreamsConsumerProperties extendedConsumerProperties) {
        String keySerdeString = extendedConsumerProperties.getKeySerde();
        return this.getKeySerde(keySerdeString);
    }

    public Serde<?> getInboundKeySerde(KafkaStreamsConsumerProperties extendedConsumerProperties, ResolvableType resolvableType) {
        String keySerdeString = extendedConsumerProperties.getKeySerde();
        return this.getKeySerde(keySerdeString, resolvableType);
    }

    public Serde<?> getInboundValueSerde(ConsumerProperties consumerProperties, KafkaStreamsConsumerProperties extendedConsumerProperties) {
        Serde<?> valueSerde;
        String valueSerdeString = extendedConsumerProperties.getValueSerde();
        try {
            valueSerde = consumerProperties != null && consumerProperties.isUseNativeDecoding() ? this.getValueSerde(valueSerdeString) : Serdes.ByteArray();
            valueSerde.configure(this.streamConfigGlobalProperties, false);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Serde class not found: ", ex);
        }
        return valueSerde;
    }

    public Serde<?> getInboundValueSerde(ConsumerProperties consumerProperties, KafkaStreamsConsumerProperties extendedConsumerProperties, ResolvableType resolvableType) {
        Serde<?> valueSerde;
        String valueSerdeString = extendedConsumerProperties.getValueSerde();
        try {
            valueSerde = consumerProperties != null && consumerProperties.isUseNativeDecoding() ? this.getValueSerde(valueSerdeString, resolvableType) : Serdes.ByteArray();
            valueSerde.configure(this.streamConfigGlobalProperties, false);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Serde class not found: ", ex);
        }
        return valueSerde;
    }

    public Serde<?> getOuboundKeySerde(KafkaStreamsProducerProperties properties) {
        return this.getKeySerde(properties.getKeySerde());
    }

    public Serde<?> getOuboundKeySerde(KafkaStreamsProducerProperties properties, ResolvableType resolvableType) {
        return this.getKeySerde(properties.getKeySerde(), resolvableType);
    }

    public Serde<?> getOutboundValueSerde(ProducerProperties producerProperties, KafkaStreamsProducerProperties kafkaStreamsProducerProperties) {
        Serde<?> valueSerde;
        try {
            valueSerde = producerProperties.isUseNativeEncoding() ? this.getValueSerde(kafkaStreamsProducerProperties.getValueSerde()) : Serdes.ByteArray();
            valueSerde.configure(this.streamConfigGlobalProperties, false);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Serde class not found: ", ex);
        }
        return valueSerde;
    }

    public Serde<?> getOutboundValueSerde(ProducerProperties producerProperties, KafkaStreamsProducerProperties kafkaStreamsProducerProperties, ResolvableType resolvableType) {
        Serde<?> valueSerde;
        try {
            valueSerde = producerProperties.isUseNativeEncoding() ? this.getValueSerde(kafkaStreamsProducerProperties.getValueSerde(), resolvableType) : Serdes.ByteArray();
            valueSerde.configure(this.streamConfigGlobalProperties, false);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Serde class not found: ", ex);
        }
        return valueSerde;
    }

    public Serde<?> getStateStoreKeySerde(String keySerdeString) {
        return this.getKeySerde(keySerdeString);
    }

    public Serde<?> getStateStoreValueSerde(String valueSerdeString) {
        try {
            return this.getValueSerde(valueSerdeString);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Serde class not found: ", ex);
        }
    }

    private Serde<?> getKeySerde(String keySerdeString) {
        Serde keySerde;
        try {
            keySerde = StringUtils.hasText((String)keySerdeString) ? (Serde)Utils.newInstance((String)keySerdeString, Serde.class) : this.getFallbackSerde("default.key.serde");
            keySerde.configure(this.streamConfigGlobalProperties, true);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Serde class not found: ", ex);
        }
        return keySerde;
    }

    private Serde<?> getKeySerde(String keySerdeString, ResolvableType resolvableType) {
        Serde<?> keySerde = null;
        try {
            if (StringUtils.hasText((String)keySerdeString)) {
                keySerde = (Serde<?>)Utils.newInstance((String)keySerdeString, Serde.class);
            } else {
                if (resolvableType != null && (this.isResolvalbeKafkaStreamsType(resolvableType) || this.isResolvableKStreamArrayType(resolvableType))) {
                    ResolvableType generic = resolvableType.isArray() ? resolvableType.getComponentType().getGeneric(new int[]{0}) : resolvableType.getGeneric(new int[]{0});
                    Serde<?> fallbackSerde = this.getFallbackSerde("default.key.serde");
                    keySerde = this.getSerde(generic, fallbackSerde);
                }
                if (keySerde == null) {
                    keySerde = Serdes.ByteArray();
                }
            }
            keySerde.configure(this.streamConfigGlobalProperties, true);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Serde class not found: ", ex);
        }
        return keySerde;
    }

    private boolean isResolvableKStreamArrayType(ResolvableType resolvableType) {
        return resolvableType.isArray() && KStream.class.isAssignableFrom(resolvableType.getComponentType().getRawClass());
    }

    private boolean isResolvalbeKafkaStreamsType(ResolvableType resolvableType) {
        return resolvableType.getRawClass() != null && (KStream.class.isAssignableFrom(resolvableType.getRawClass()) || KTable.class.isAssignableFrom(resolvableType.getRawClass()) || GlobalKTable.class.isAssignableFrom(resolvableType.getRawClass()));
    }

    private Serde<?> getSerde(ResolvableType generic, Serde<?> fallbackSerde) {
        JsonSerde serde = null;
        Map beansOfType = this.context.getBeansOfType(Serde.class);
        Serde[] serdeBeans = new Serde[1];
        Class genericRawClazz = generic.getRawClass();
        beansOfType.forEach((k, v) -> {
            Class classObj = ClassUtils.resolveClassName((String)((AnnotatedBeanDefinition)this.context.getBeanFactory().getBeanDefinition(k)).getMetadata().getClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
            try {
                Method method;
                ResolvableType resolvableType;
                ResolvableType serdeBeanGeneric;
                Class serdeGenericRawClazz;
                Method[] methods = classObj.getMethods();
                Optional<Method> serdeBeanMethod = Arrays.stream(methods).filter(m -> m.getName().equals(k)).findFirst();
                if (serdeBeanMethod.isPresent() && (serdeGenericRawClazz = (serdeBeanGeneric = (resolvableType = ResolvableType.forMethodReturnType((Method)(method = serdeBeanMethod.get()), (Class)classObj)).getGeneric(new int[]{0})).getRawClass()) != null && genericRawClazz != null && serdeGenericRawClazz.isAssignableFrom(genericRawClazz)) {
                    serdeBeans[0] = v;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        if (serdeBeans[0] != null) {
            return serdeBeans[0];
        }
        if (genericRawClazz != null) {
            if (Integer.class.isAssignableFrom(genericRawClazz)) {
                serde = Serdes.Integer();
            } else if (Long.class.isAssignableFrom(genericRawClazz)) {
                serde = Serdes.Long();
            } else if (Short.class.isAssignableFrom(genericRawClazz)) {
                serde = Serdes.Short();
            } else if (Double.class.isAssignableFrom(genericRawClazz)) {
                serde = Serdes.Double();
            } else if (Float.class.isAssignableFrom(genericRawClazz)) {
                serde = Serdes.Float();
            } else if (byte[].class.isAssignableFrom(genericRawClazz)) {
                serde = Serdes.ByteArray();
            } else if (String.class.isAssignableFrom(genericRawClazz)) {
                serde = Serdes.String();
            } else if (UUID.class.isAssignableFrom(genericRawClazz)) {
                serde = Serdes.UUID();
            } else if (!this.isSerdeFromStandardDefaults((Serde<?>)fallbackSerde)) {
                serde = fallbackSerde;
            } else if (!genericRawClazz.isAssignableFrom(Object.class)) {
                serde = new JsonSerde(genericRawClazz);
            }
        }
        return serde;
    }

    private boolean isSerdeFromStandardDefaults(Serde<?> serde) {
        if (serde != null) {
            if (Number.class.isAssignableFrom(serde.getClass())) {
                return true;
            }
            if (Serdes.ByteArray().getClass().isAssignableFrom(serde.getClass())) {
                return true;
            }
            if (Serdes.String().getClass().isAssignableFrom(serde.getClass())) {
                return true;
            }
            if (Serdes.UUID().getClass().isAssignableFrom(serde.getClass())) {
                return true;
            }
        }
        return false;
    }

    private Serde<?> getValueSerde(String valueSerdeString) throws ClassNotFoundException {
        Serde valueSerde = StringUtils.hasText((String)valueSerdeString) ? (Serde)Utils.newInstance((String)valueSerdeString, Serde.class) : this.getFallbackSerde("default.value.serde");
        return valueSerde;
    }

    private Serde<?> getFallbackSerde(String s) throws ClassNotFoundException {
        return this.binderConfigurationProperties.getConfiguration().containsKey(s) ? (Serde)Utils.newInstance((String)((String)this.binderConfigurationProperties.getConfiguration().get(s)), Serde.class) : Serdes.ByteArray();
    }

    private Serde<?> getValueSerde(String valueSerdeString, ResolvableType resolvableType) throws ClassNotFoundException {
        Serde<?> valueSerde = null;
        if (StringUtils.hasText((String)valueSerdeString)) {
            valueSerde = (Serde<?>)Utils.newInstance((String)valueSerdeString, Serde.class);
        } else {
            if (resolvableType != null && (this.isResolvalbeKafkaStreamsType(resolvableType) || this.isResolvableKStreamArrayType(resolvableType))) {
                Serde<?> fallbackSerde = this.getFallbackSerde("default.value.serde");
                ResolvableType generic = resolvableType.isArray() ? resolvableType.getComponentType().getGeneric(new int[]{1}) : resolvableType.getGeneric(new int[]{1});
                valueSerde = this.getSerde(generic, fallbackSerde);
            }
            if (valueSerde == null) {
                valueSerde = Serdes.ByteArray();
            }
        }
        return valueSerde;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = (ConfigurableApplicationContext)applicationContext;
    }
}

