/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams.serde;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

public class CompositeNonNativeSerde<T>
implements Serde<T> {
    private static final String VALUE_CLASS_HEADER = "valueClass";
    private static final String AVRO_FORMAT = "avro";
    private static final MimeType DEFAULT_AVRO_MIME_TYPE = new MimeType("application", "*+avro");
    private final CompositeNonNativeDeserializer<T> compositeNonNativeDeserializer;
    private final CompositeNonNativeSerializer<T> compositeNonNativeSerializer;

    public CompositeNonNativeSerde(CompositeMessageConverterFactory compositeMessageConverterFactory) {
        this.compositeNonNativeDeserializer = new CompositeNonNativeDeserializer(compositeMessageConverterFactory);
        this.compositeNonNativeSerializer = new CompositeNonNativeSerializer(compositeMessageConverterFactory);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.compositeNonNativeDeserializer.configure(configs, isKey);
        this.compositeNonNativeSerializer.configure(configs, isKey);
    }

    public void close() {
    }

    public Serializer<T> serializer() {
        return this.compositeNonNativeSerializer;
    }

    public Deserializer<T> deserializer() {
        return this.compositeNonNativeDeserializer;
    }

    private static MimeType resolveMimeType(Map<String, ?> configs) {
        if (configs.containsKey("contentType")) {
            String contentType = (String)configs.get("contentType");
            if (DEFAULT_AVRO_MIME_TYPE.equals((Object)MimeTypeUtils.parseMimeType((String)contentType))) {
                return DEFAULT_AVRO_MIME_TYPE;
            }
            if (contentType.contains(AVRO_FORMAT)) {
                return MimeTypeUtils.parseMimeType((String)"application/avro");
            }
            return new MimeType("application", "json", StandardCharsets.UTF_8);
        }
        return new MimeType("application", "json", StandardCharsets.UTF_8);
    }

    private static class CompositeNonNativeSerializer<V>
    implements Serializer<V> {
        private final MessageConverter messageConverter;
        private MimeType mimeType;

        CompositeNonNativeSerializer(CompositeMessageConverterFactory compositeMessageConverterFactory) {
            this.messageConverter = compositeMessageConverterFactory.getMessageConverterForAllRegistered();
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.mimeType = CompositeNonNativeSerde.resolveMimeType(configs);
        }

        public byte[] serialize(String topic, V data) {
            Message message = MessageBuilder.withPayload(data).build();
            HashMap<String, String> headers = new HashMap<String, String>((Map<String, String>)message.getHeaders());
            headers.put("contentType", this.mimeType.toString());
            MessageHeaders messageHeaders = new MessageHeaders(headers);
            Object payload = this.messageConverter.toMessage(message.getPayload(), messageHeaders).getPayload();
            return (byte[])payload;
        }

        public void close() {
        }
    }

    private static class CompositeNonNativeDeserializer<U>
    implements Deserializer<U> {
        private final MessageConverter messageConverter;
        private MimeType mimeType;
        private Class<?> valueClass;

        CompositeNonNativeDeserializer(CompositeMessageConverterFactory compositeMessageConverterFactory) {
            this.messageConverter = compositeMessageConverterFactory.getMessageConverterForAllRegistered();
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            Assert.isTrue((boolean)configs.containsKey(CompositeNonNativeSerde.VALUE_CLASS_HEADER), (String)"Deserializers must provide a configuration for valueClass.");
            Object valueClass = configs.get(CompositeNonNativeSerde.VALUE_CLASS_HEADER);
            Assert.isTrue((boolean)(valueClass instanceof Class), (String)"Deserializers must provide a valid value for valueClass.");
            this.valueClass = (Class)valueClass;
            this.mimeType = CompositeNonNativeSerde.resolveMimeType(configs);
        }

        public U deserialize(String topic, byte[] data) {
            Message message = MessageBuilder.withPayload((Object)data).setHeader("contentType", (Object)this.mimeType.toString()).build();
            Object messageConverted = this.messageConverter.fromMessage(message, this.valueClass);
            Assert.notNull((Object)messageConverted, (String)"Deserialization failed.");
            return (U)messageConverted;
        }

        public void close() {
        }
    }
}

