/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.Map;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaConsumerProperties;
import org.springframework.cloud.stream.binder.kafka.provisioning.KafkaTopicProvisioner;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsDlqDispatch;
import org.springframework.cloud.stream.binder.kafka.streams.SendToDlqAndContinue;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsConsumerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

final class KafkaStreamsBinderUtils {
    private KafkaStreamsBinderUtils() {
    }

    static void prepareConsumerBinding(String name, String group, ApplicationContext context, KafkaTopicProvisioner kafkaTopicProvisioner, KafkaStreamsBinderConfigurationProperties binderConfigurationProperties, ExtendedConsumerProperties<KafkaStreamsConsumerProperties> properties, Map<String, KafkaStreamsDlqDispatch> kafkaStreamsDlqDispatchers) {
        String[] inputTopics;
        ExtendedConsumerProperties extendedConsumerProperties = new ExtendedConsumerProperties(properties.getExtension());
        if (binderConfigurationProperties.getSerdeError() == KafkaStreamsBinderConfigurationProperties.SerdeError.sendToDlq) {
            ((KafkaConsumerProperties)extendedConsumerProperties.getExtension()).setEnableDlq(true);
        }
        for (String inputTopic : inputTopics = StringUtils.commaDelimitedListToStringArray((String)name)) {
            kafkaTopicProvisioner.provisionConsumerDestination(inputTopic, group, extendedConsumerProperties);
        }
        if (((KafkaConsumerProperties)extendedConsumerProperties.getExtension()).isEnableDlq()) {
            KafkaStreamsDlqDispatch kafkaStreamsDlqDispatch = !StringUtils.isEmpty((Object)((KafkaConsumerProperties)extendedConsumerProperties.getExtension()).getDlqName()) ? new KafkaStreamsDlqDispatch(((KafkaConsumerProperties)extendedConsumerProperties.getExtension()).getDlqName(), binderConfigurationProperties, (KafkaConsumerProperties)extendedConsumerProperties.getExtension()) : null;
            for (String inputTopic : inputTopics) {
                if (StringUtils.isEmpty((Object)((KafkaConsumerProperties)extendedConsumerProperties.getExtension()).getDlqName())) {
                    String dlqName = "error." + inputTopic + "." + group;
                    kafkaStreamsDlqDispatch = new KafkaStreamsDlqDispatch(dlqName, binderConfigurationProperties, (KafkaConsumerProperties)extendedConsumerProperties.getExtension());
                }
                SendToDlqAndContinue sendToDlqAndContinue = (SendToDlqAndContinue)context.getBean(SendToDlqAndContinue.class);
                sendToDlqAndContinue.addKStreamDlqDispatch(inputTopic, kafkaStreamsDlqDispatch);
                kafkaStreamsDlqDispatchers.put(inputTopic, kafkaStreamsDlqDispatch);
            }
        }
    }
}

