/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.kafka.streams.kstream.KStream;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBindingInformationCatalogue;
import org.springframework.cloud.stream.binding.AbstractBindingTargetFactory;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.util.Assert;

class KStreamBoundElementFactory
extends AbstractBindingTargetFactory<KStream> {
    private final BindingServiceProperties bindingServiceProperties;
    private final KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue;

    KStreamBoundElementFactory(BindingServiceProperties bindingServiceProperties, KafkaStreamsBindingInformationCatalogue KafkaStreamsBindingInformationCatalogue2) {
        super(KStream.class);
        this.bindingServiceProperties = bindingServiceProperties;
        this.kafkaStreamsBindingInformationCatalogue = KafkaStreamsBindingInformationCatalogue2;
    }

    public KStream createInput(String name) {
        ConsumerProperties consumerProperties = this.bindingServiceProperties.getConsumerProperties(name);
        consumerProperties.setMultiplex(true);
        return this.createProxyForKStream(name);
    }

    public KStream createOutput(String name) {
        return this.createProxyForKStream(name);
    }

    private KStream createProxyForKStream(String name) {
        KStreamWrapperHandler wrapper = new KStreamWrapperHandler();
        ProxyFactory proxyFactory = new ProxyFactory(new Class[]{KStreamWrapper.class, KStream.class});
        proxyFactory.addAdvice((Advice)wrapper);
        KStream proxy = (KStream)proxyFactory.getProxy();
        BindingProperties bindingProperties = this.bindingServiceProperties.getBindingProperties(name);
        this.kafkaStreamsBindingInformationCatalogue.registerBindingProperties(proxy, bindingProperties);
        return proxy;
    }

    private static class KStreamWrapperHandler
    implements KStreamWrapper,
    MethodInterceptor {
        private KStream<Object, Object> delegate;

        private KStreamWrapperHandler() {
        }

        @Override
        public void wrap(KStream<Object, Object> delegate) {
            Assert.notNull(delegate, (String)"delegate cannot be null");
            Assert.isNull(this.delegate, (String)("delegate already set to " + this.delegate));
            this.delegate = delegate;
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            if (methodInvocation.getMethod().getDeclaringClass().equals(KStream.class)) {
                Assert.notNull(this.delegate, (String)("Trying to prepareConsumerBinding " + methodInvocation.getMethod() + "  but no delegate has been set."));
                return methodInvocation.getMethod().invoke(this.delegate, methodInvocation.getArguments());
            }
            if (methodInvocation.getMethod().getDeclaringClass().equals(KStreamWrapper.class)) {
                return methodInvocation.getMethod().invoke((Object)this, methodInvocation.getArguments());
            }
            throw new IllegalStateException("Only KStream method invocations are permitted");
        }
    }

    public static interface KStreamWrapper {
        public void wrap(KStream<Object, Object> var1);
    }
}

