/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.errors.LogAndContinueExceptionHandler;
import org.apache.kafka.streams.errors.LogAndFailExceptionHandler;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.BinderConfiguration;
import org.springframework.cloud.stream.binder.kafka.streams.GlobalKTableBoundElementFactory;
import org.springframework.cloud.stream.binder.kafka.streams.InteractiveQueryService;
import org.springframework.cloud.stream.binder.kafka.streams.KStreamBoundElementFactory;
import org.springframework.cloud.stream.binder.kafka.streams.KStreamStreamListenerParameterAdapter;
import org.springframework.cloud.stream.binder.kafka.streams.KStreamStreamListenerResultAdapter;
import org.springframework.cloud.stream.binder.kafka.streams.KTableBoundElementFactory;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBindingInformationCatalogue;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsDlqDispatch;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsMessageConversionDelegate;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsRegistry;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsStreamListenerSetupMethodOrchestrator;
import org.springframework.cloud.stream.binder.kafka.streams.KeyValueSerdeResolver;
import org.springframework.cloud.stream.binder.kafka.streams.QueryableStoreRegistry;
import org.springframework.cloud.stream.binder.kafka.streams.SendToDlqAndContinue;
import org.springframework.cloud.stream.binder.kafka.streams.StreamsBuilderFactoryManager;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsExtendedBindingProperties;
import org.springframework.cloud.stream.binder.kafka.streams.serde.CompositeNonNativeSerde;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.binding.StreamListenerResultAdapter;
import org.springframework.cloud.stream.config.BinderProperties;
import org.springframework.cloud.stream.config.BindingServiceConfiguration;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.kafka.config.KafkaStreamsConfiguration;
import org.springframework.kafka.core.CleanupConfig;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@EnableConfigurationProperties(value={KafkaStreamsExtendedBindingProperties.class})
@ConditionalOnBean(value={BindingService.class})
@AutoConfigureAfter(value={BindingServiceConfiguration.class})
public class KafkaStreamsBinderSupportAutoConfiguration {
    private static final String KSTREAM_BINDER_TYPE = "kstream";
    private static final String KTABLE_BINDER_TYPE = "ktable";
    private static final String GLOBALKTABLE_BINDER_TYPE = "globalktable";

    @Bean
    @ConfigurationProperties(prefix="spring.cloud.stream.kafka.streams.binder")
    public KafkaStreamsBinderConfigurationProperties binderConfigurationProperties(KafkaProperties kafkaProperties, ConfigurableEnvironment environment, BindingServiceProperties bindingServiceProperties) {
        Map<String, BinderConfiguration> binderConfigurations = KafkaStreamsBinderSupportAutoConfiguration.getBinderConfigurations(bindingServiceProperties);
        for (Map.Entry<String, BinderConfiguration> entry : binderConfigurations.entrySet()) {
            BinderConfiguration binderConfiguration = entry.getValue();
            String binderType = binderConfiguration.getBinderType();
            if (binderType == null || !binderType.equals(KSTREAM_BINDER_TYPE) && !binderType.equals(KTABLE_BINDER_TYPE) && !binderType.equals(GLOBALKTABLE_BINDER_TYPE)) continue;
            HashMap<String, Object> binderProperties = new HashMap<String, Object>();
            this.flatten(null, binderConfiguration.getProperties(), binderProperties);
            environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("kafkaStreamsBinderEnv", binderProperties));
        }
        return new KafkaStreamsBinderConfigurationProperties(kafkaProperties);
    }

    private static Map<String, BinderConfiguration> getBinderConfigurations(BindingServiceProperties bindingServiceProperties) {
        HashMap<String, BinderConfiguration> binderConfigurations = new HashMap<String, BinderConfiguration>();
        Map declaredBinders = bindingServiceProperties.getBinders();
        for (Map.Entry binderEntry : declaredBinders.entrySet()) {
            BinderProperties binderProperties = (BinderProperties)binderEntry.getValue();
            binderConfigurations.put((String)binderEntry.getKey(), new BinderConfiguration(binderProperties.getType(), binderProperties.getEnvironment(), binderProperties.isInheritEnvironment(), binderProperties.isDefaultCandidate()));
        }
        return binderConfigurations;
    }

    private void flatten(String propertyName, Object value, Map<String, Object> flattenedProperties) {
        if (value instanceof Map) {
            ((Map)value).forEach((k, v) -> this.flatten((propertyName != null ? propertyName + "." : "") + k, v, flattenedProperties));
        } else {
            flattenedProperties.put(propertyName, value.toString());
        }
    }

    @Bean
    public KafkaStreamsConfiguration kafkaStreamsConfiguration(KafkaStreamsBinderConfigurationProperties binderConfigurationProperties, Environment environment) {
        String applicationName;
        KafkaProperties kafkaProperties = binderConfigurationProperties.getKafkaProperties();
        Map streamsProperties = kafkaProperties.buildStreamsProperties();
        if (kafkaProperties.getStreams().getApplicationId() == null && (applicationName = environment.getProperty("spring.application.name")) != null) {
            streamsProperties.put("application.id", applicationName);
        }
        return new KafkaStreamsConfiguration(streamsProperties);
    }

    @Bean(value={"streamConfigGlobalProperties"})
    public Map<String, Object> streamConfigGlobalProperties(KafkaStreamsBinderConfigurationProperties binderConfigurationProperties, KafkaStreamsConfiguration kafkaStreamsConfiguration) {
        Properties properties = kafkaStreamsConfiguration.asProperties();
        if (ObjectUtils.isEmpty((Object)properties.get("bootstrap.servers"))) {
            properties.put("bootstrap.servers", binderConfigurationProperties.getKafkaConnectionString());
        } else {
            String bootStrapServers;
            Object bootstrapServerConfig = properties.get("bootstrap.servers");
            if (bootstrapServerConfig instanceof String && (bootStrapServers = (String)properties.get("bootstrap.servers")).equals("localhost:9092")) {
                properties.put("bootstrap.servers", binderConfigurationProperties.getKafkaConnectionString());
            }
        }
        String binderProvidedApplicationId = binderConfigurationProperties.getApplicationId();
        if (StringUtils.hasText((String)binderProvidedApplicationId)) {
            properties.put("application.id", binderProvidedApplicationId);
        }
        properties.put("default.key.serde", Serdes.ByteArraySerde.class.getName());
        properties.put("default.value.serde", Serdes.ByteArraySerde.class.getName());
        if (binderConfigurationProperties.getSerdeError() == KafkaStreamsBinderConfigurationProperties.SerdeError.logAndContinue) {
            properties.put("default.deserialization.exception.handler", LogAndContinueExceptionHandler.class.getName());
        } else if (binderConfigurationProperties.getSerdeError() == KafkaStreamsBinderConfigurationProperties.SerdeError.logAndFail) {
            properties.put("default.deserialization.exception.handler", LogAndFailExceptionHandler.class.getName());
        } else if (binderConfigurationProperties.getSerdeError() == KafkaStreamsBinderConfigurationProperties.SerdeError.sendToDlq) {
            properties.put("default.deserialization.exception.handler", SendToDlqAndContinue.class.getName());
        }
        if (!ObjectUtils.isEmpty((Object)binderConfigurationProperties.getConfiguration())) {
            properties.putAll((Map<?, ?>)binderConfigurationProperties.getConfiguration());
        }
        return properties.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), Map.Entry::getValue));
    }

    @Bean
    public KStreamStreamListenerResultAdapter kstreamStreamListenerResultAdapter() {
        return new KStreamStreamListenerResultAdapter();
    }

    @Bean
    public KStreamStreamListenerParameterAdapter kstreamStreamListenerParameterAdapter(KafkaStreamsMessageConversionDelegate kstreamBoundMessageConversionDelegate, KafkaStreamsBindingInformationCatalogue KafkaStreamsBindingInformationCatalogue2) {
        return new KStreamStreamListenerParameterAdapter(kstreamBoundMessageConversionDelegate, KafkaStreamsBindingInformationCatalogue2);
    }

    @Bean
    public KafkaStreamsStreamListenerSetupMethodOrchestrator kafkaStreamsStreamListenerSetupMethodOrchestrator(BindingServiceProperties bindingServiceProperties, KafkaStreamsExtendedBindingProperties kafkaStreamsExtendedBindingProperties, KeyValueSerdeResolver keyValueSerdeResolver, KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue, KStreamStreamListenerParameterAdapter kafkaStreamListenerParameterAdapter, Collection<StreamListenerResultAdapter> streamListenerResultAdapters, ObjectProvider<CleanupConfig> cleanupConfig) {
        return new KafkaStreamsStreamListenerSetupMethodOrchestrator(bindingServiceProperties, kafkaStreamsExtendedBindingProperties, keyValueSerdeResolver, kafkaStreamsBindingInformationCatalogue, kafkaStreamListenerParameterAdapter, streamListenerResultAdapters, (CleanupConfig)cleanupConfig.getIfUnique());
    }

    @Bean
    public KafkaStreamsMessageConversionDelegate messageConversionDelegate(CompositeMessageConverterFactory compositeMessageConverterFactory, SendToDlqAndContinue sendToDlqAndContinue, KafkaStreamsBindingInformationCatalogue KafkaStreamsBindingInformationCatalogue2, KafkaStreamsBinderConfigurationProperties binderConfigurationProperties) {
        return new KafkaStreamsMessageConversionDelegate(compositeMessageConverterFactory, sendToDlqAndContinue, KafkaStreamsBindingInformationCatalogue2, binderConfigurationProperties);
    }

    @Bean
    public CompositeNonNativeSerde compositeNonNativeSerde(CompositeMessageConverterFactory compositeMessageConverterFactory) {
        return new CompositeNonNativeSerde(compositeMessageConverterFactory);
    }

    @Bean
    public KStreamBoundElementFactory kStreamBoundElementFactory(BindingServiceProperties bindingServiceProperties, KafkaStreamsBindingInformationCatalogue KafkaStreamsBindingInformationCatalogue2) {
        return new KStreamBoundElementFactory(bindingServiceProperties, KafkaStreamsBindingInformationCatalogue2);
    }

    @Bean
    public KTableBoundElementFactory kTableBoundElementFactory(BindingServiceProperties bindingServiceProperties) {
        return new KTableBoundElementFactory(bindingServiceProperties);
    }

    @Bean
    public GlobalKTableBoundElementFactory globalKTableBoundElementFactory(BindingServiceProperties bindingServiceProperties) {
        return new GlobalKTableBoundElementFactory(bindingServiceProperties);
    }

    @Bean
    public SendToDlqAndContinue sendToDlqAndContinue() {
        return new SendToDlqAndContinue();
    }

    @Bean
    public KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue() {
        return new KafkaStreamsBindingInformationCatalogue();
    }

    @Bean
    public KeyValueSerdeResolver keyValueSerdeResolver(@Qualifier(value="streamConfigGlobalProperties") Object streamConfigGlobalProperties, KafkaStreamsBinderConfigurationProperties kafkaStreamsBinderConfigurationProperties) {
        return new KeyValueSerdeResolver((Map)streamConfigGlobalProperties, kafkaStreamsBinderConfigurationProperties);
    }

    @Bean
    public QueryableStoreRegistry queryableStoreTypeRegistry(KafkaStreamsRegistry kafkaStreamsRegistry) {
        return new QueryableStoreRegistry(kafkaStreamsRegistry);
    }

    @Bean
    public InteractiveQueryService interactiveQueryServices(KafkaStreamsRegistry kafkaStreamsRegistry, KafkaStreamsBinderConfigurationProperties binderConfigurationProperties) {
        return new InteractiveQueryService(kafkaStreamsRegistry, binderConfigurationProperties);
    }

    @Bean
    public KafkaStreamsRegistry kafkaStreamsRegistry() {
        return new KafkaStreamsRegistry();
    }

    @Bean
    public StreamsBuilderFactoryManager streamsBuilderFactoryManager(KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue, KafkaStreamsRegistry kafkaStreamsRegistry) {
        return new StreamsBuilderFactoryManager(kafkaStreamsBindingInformationCatalogue, kafkaStreamsRegistry);
    }

    @Bean(value={"kafkaStreamsDlqDispatchers"})
    public Map<String, KafkaStreamsDlqDispatch> dlqDispatchers() {
        return new HashMap<String, KafkaStreamsDlqDispatch>();
    }
}

