/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.autoconfigure.jdbc;

import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.autoconfigure.DataSourceProperties;
import org.springframework.cloud.task.configuration.DefaultTaskConfigurer;
import org.springframework.cloud.task.configuration.TaskConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

class JDBCSingleStepDataSourceAutoConfiguration {
    JDBCSingleStepDataSourceAutoConfiguration() {
    }

    @ConditionalOnMissingBean
    @Bean
    public TaskConfigurer myTaskConfigurer(DataSource dataSource) {
        return new DefaultTaskConfigurer(dataSource);
    }

    @ConditionalOnProperty(prefix="spring.batch.job.jdbcsinglestep.datasource", name={"enable"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(name={"springDataSourceProperties"})
    @Bean(name={"springDataSourceProperties"})
    @ConfigurationProperties(value="spring.datasource")
    @Primary
    public DataSourceProperties springDataSourceProperties() {
        return new DataSourceProperties();
    }

    @ConditionalOnProperty(prefix="spring.batch.job.jdbcsinglestep.datasource", name={"enable"}, havingValue="true", matchIfMissing=true)
    @Bean(name={"springDataSource"})
    @Primary
    public DataSource dataSource(@Qualifier(value="springDataSourceProperties") DataSourceProperties springDataSourceProperties) {
        DataSource dataSource = springDataSourceProperties.initializeDataSourceBuilder().build();
        return dataSource;
    }
}

