/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.autoconfigure.flatfile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.infrastructure.item.file.FlatFileItemReader;
import org.springframework.batch.infrastructure.item.file.LineCallbackHandler;
import org.springframework.batch.infrastructure.item.file.LineMapper;
import org.springframework.batch.infrastructure.item.file.builder.FlatFileItemReaderBuilder;
import org.springframework.batch.infrastructure.item.file.mapping.FieldSetMapper;
import org.springframework.batch.infrastructure.item.file.separator.RecordSeparatorPolicy;
import org.springframework.batch.infrastructure.item.file.transform.FieldSet;
import org.springframework.batch.infrastructure.item.file.transform.LineTokenizer;
import org.springframework.batch.infrastructure.item.file.transform.Range;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.batch.autoconfigure.BatchAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.task.batch.autoconfigure.RangeConverter;
import org.springframework.cloud.task.batch.autoconfigure.flatfile.FlatFileItemReaderProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={FlatFileItemReaderProperties.class})
@AutoConfigureAfter(value={BatchAutoConfiguration.class})
public class FlatFileItemReaderAutoConfiguration {
    private static final Log logger = LogFactory.getLog(FlatFileItemReaderAutoConfiguration.class);
    private final FlatFileItemReaderProperties properties;

    public FlatFileItemReaderAutoConfiguration(FlatFileItemReaderProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.batch.job.flatfileitemreader", name={"name"})
    public FlatFileItemReader<Map<String, Object>> itemReader(@Autowired(required=false) LineTokenizer lineTokenizer, @Autowired(required=false) FieldSetMapper<Map<String, Object>> fieldSetMapper, @Autowired(required=false) LineMapper<Map<String, Object>> lineMapper, @Autowired(required=false) LineCallbackHandler skippedLinesCallback, @Autowired(required=false) RecordSeparatorPolicy recordSeparatorPolicy) {
        FlatFileItemReaderBuilder mapFlatFileItemReaderBuilder = new FlatFileItemReaderBuilder().name(this.properties.getName()).resource(this.properties.getResource()).saveState(this.properties.isSaveState()).maxItemCount(this.properties.getMaxItemCount()).currentItemCount(this.properties.getCurrentItemCount()).strict(this.properties.isStrict()).encoding(this.properties.getEncoding()).linesToSkip(this.properties.getLinesToSkip()).comments(this.properties.getComments().toArray(new String[this.properties.getComments().size()]));
        if (recordSeparatorPolicy != null) {
            mapFlatFileItemReaderBuilder.recordSeparatorPolicy(recordSeparatorPolicy);
        }
        mapFlatFileItemReaderBuilder.fieldSetMapper(fieldSetMapper);
        mapFlatFileItemReaderBuilder.lineMapper(lineMapper);
        mapFlatFileItemReaderBuilder.skippedLinesCallback(skippedLinesCallback);
        if (this.properties.isDelimited()) {
            mapFlatFileItemReaderBuilder.delimited().quoteCharacter(this.properties.getQuoteCharacter()).delimiter(this.properties.getDelimiter()).includedFields(this.properties.getIncludedFields().toArray(new Integer[0])).names(this.properties.getNames()).beanMapperStrict(this.properties.isParsingStrict()).fieldSetMapper((FieldSetMapper)new MapFieldSetMapper());
        } else if (this.properties.isFixedLength()) {
            RangeConverter rangeConverter = new RangeConverter();
            ArrayList ranges = new ArrayList();
            this.properties.getRanges().forEach(range -> ranges.add(rangeConverter.convert((String)range)));
            mapFlatFileItemReaderBuilder.fixedLength().columns(ranges.toArray(new Range[0])).names(this.properties.getNames()).fieldSetMapper((FieldSetMapper)new MapFieldSetMapper()).beanMapperStrict(this.properties.isParsingStrict());
        } else {
            mapFlatFileItemReaderBuilder.lineTokenizer(lineTokenizer);
        }
        if (lineTokenizer != null && (this.properties.isDelimited() || this.properties.isFixedLength())) {
            logger.warn((Object)"Custom LineTokenizer bean provided but will be ignored because delimited or fixed-length properties are configured. Remove the custom bean or clear delimited/fixedLength properties.");
        }
        return mapFlatFileItemReaderBuilder.build();
    }

    public static class MapFieldSetMapper
    implements FieldSetMapper<Map<String, Object>> {
        public Map<String, Object> mapFieldSet(FieldSet fieldSet) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            fieldSet.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> map.put(key.toString(), value)));
            return map;
        }
    }
}

