/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.autoconfigure.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.infrastructure.item.database.JdbcCursorItemReader;
import org.springframework.batch.infrastructure.item.database.builder.JdbcCursorItemReaderBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.batch.autoconfigure.BatchAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.autoconfigure.DataSourceProperties;
import org.springframework.cloud.task.batch.autoconfigure.jdbc.JDBCSingleStepDataSourceAutoConfiguration;
import org.springframework.cloud.task.batch.autoconfigure.jdbc.JdbcCursorItemReaderProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;

@AutoConfiguration
@EnableConfigurationProperties(value={JdbcCursorItemReaderProperties.class})
@AutoConfigureAfter(value={BatchAutoConfiguration.class})
@ConditionalOnProperty(prefix="spring.batch.job.jdbccursoritemreader", name={"name"})
@Import(value={JDBCSingleStepDataSourceAutoConfiguration.class})
public class JdbcCursorItemReaderAutoConfiguration {
    private static final Log logger = LogFactory.getLog(JdbcCursorItemReaderAutoConfiguration.class);
    @Autowired
    ApplicationContext applicationContext;
    private final JdbcCursorItemReaderProperties properties;
    private final DataSource dataSource;

    public JdbcCursorItemReaderAutoConfiguration(JdbcCursorItemReaderProperties properties, DataSource dataSource) {
        this.properties = properties;
        this.dataSource = dataSource;
    }

    @Bean
    @ConditionalOnMissingBean
    public JdbcCursorItemReader<Map<String, Object>> itemReader(@Autowired(required=false) RowMapper<Map<String, Object>> rowMapper, @Autowired(required=false) PreparedStatementSetter preparedStatementSetter) {
        DataSource readerDataSource = this.dataSource;
        try {
            readerDataSource = (DataSource)this.applicationContext.getBean("jdbcCursorItemReaderSpringDataSource", DataSource.class);
        }
        catch (Exception e) {
            logger.info((Object)"Using Default Data Source for the JdbcCursorItemReader");
        }
        return new JdbcCursorItemReaderBuilder().name(this.properties.getName()).currentItemCount(this.properties.getCurrentItemCount()).dataSource(readerDataSource).driverSupportsAbsolute(this.properties.isDriverSupportsAbsolute()).fetchSize(this.properties.getFetchSize()).ignoreWarnings(this.properties.isIgnoreWarnings()).maxItemCount(this.properties.getMaxItemCount()).maxRows(this.properties.getMaxRows()).queryTimeout(this.properties.getQueryTimeout()).saveState(this.properties.isSaveState()).sql(this.properties.getSql()).rowMapper(rowMapper).preparedStatementSetter(preparedStatementSetter).verifyCursorPosition(this.properties.isVerifyCursorPosition()).useSharedExtendedConnection(this.properties.isUseSharedExtendedConnection()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public RowMapper<Map<String, Object>> rowMapper() {
        return new MapRowMapper();
    }

    @ConditionalOnProperty(prefix="spring.batch.job.jdbccursoritemreader.datasource", name={"enable"}, havingValue="true")
    @Bean(name={"jdbcCursorItemReaderDataSourceProperties"})
    @ConfigurationProperties(value="jdbccursoritemreader.datasource")
    public DataSourceProperties jdbcCursorItemReaderDataSourceProperties() {
        return new DataSourceProperties();
    }

    @ConditionalOnProperty(prefix="spring.batch.job.jdbccursoritemreader.datasource", name={"enable"}, havingValue="true")
    @Bean(name={"jdbcCursorItemReaderSpringDataSource"})
    public DataSource readerDataSource(@Qualifier(value="jdbcCursorItemReaderDataSourceProperties") DataSourceProperties readerDataSourceProperties) {
        DataSource result = readerDataSourceProperties.initializeDataSourceBuilder().build();
        return result;
    }

    public static class MapRowMapper
    implements RowMapper<Map<String, Object>> {
        public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
            HashMap<String, Object> item = new HashMap<String, Object>(rs.getMetaData().getColumnCount());
            for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                item.put(rs.getMetaData().getColumnName(i), rs.getObject(i));
            }
            return item;
        }
    }
}

