/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.autoconfigure.kafka;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.springframework.batch.item.kafka.KafkaItemReader;
import org.springframework.batch.item.kafka.builder.KafkaItemReaderBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.batch.BatchAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.task.batch.autoconfigure.kafka.KafkaItemReaderProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={KafkaProperties.class, KafkaItemReaderProperties.class})
@AutoConfigureAfter(value={BatchAutoConfiguration.class})
public class KafkaItemReaderAutoConfiguration {
    @Autowired
    private KafkaProperties kafkaProperties;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.batch.job.kafkaitemreader", name={"name"})
    public KafkaItemReader<Object, Map<String, Object>> kafkaItemReader(KafkaItemReaderProperties kafkaItemReaderProperties) {
        Properties consumerProperties = new Properties();
        consumerProperties.putAll((Map<?, ?>)this.kafkaProperties.getConsumer().buildProperties());
        this.validateProperties(kafkaItemReaderProperties);
        if (kafkaItemReaderProperties.getPartitions() == null || kafkaItemReaderProperties.getPartitions().size() == 0) {
            kafkaItemReaderProperties.setPartitions(new ArrayList<Integer>(1));
            kafkaItemReaderProperties.getPartitions().add(0);
        }
        return new KafkaItemReaderBuilder().partitions(kafkaItemReaderProperties.getPartitions()).consumerProperties(consumerProperties).name(kafkaItemReaderProperties.getName()).pollTimeout(Duration.ofSeconds(kafkaItemReaderProperties.getPollTimeOutInSeconds())).saveState(kafkaItemReaderProperties.isSaveState()).topic(kafkaItemReaderProperties.getTopic()).build();
    }

    private void validateProperties(KafkaItemReaderProperties kafkaItemReaderProperties) {
        if (!StringUtils.hasText((String)kafkaItemReaderProperties.getName())) {
            throw new IllegalArgumentException("Name must not be empty or null");
        }
        if (!StringUtils.hasText((String)kafkaItemReaderProperties.getTopic())) {
            throw new IllegalArgumentException("Topic must not be empty or null");
        }
        if (!StringUtils.hasText((String)this.kafkaProperties.getConsumer().getGroupId())) {
            throw new IllegalArgumentException("GroupId must not be empty or null");
        }
        if (this.kafkaProperties.getBootstrapServers() == null || this.kafkaProperties.getBootstrapServers().size() == 0) {
            throw new IllegalArgumentException("Bootstrap Servers must be configured");
        }
    }
}

