/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.autoconfigure.rabbit;

import java.util.Map;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.batch.item.amqp.AmqpItemWriter;
import org.springframework.batch.item.amqp.builder.AmqpItemWriterBuilder;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.batch.BatchAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.task.batch.autoconfigure.rabbit.AmqpItemWriterProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={AmqpItemWriterProperties.class})
@AutoConfigureAfter(value={BatchAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.batch.job.amqpitemwriter.enabled"}, havingValue="true", matchIfMissing=false)
public class AmqpItemWriterAutoConfiguration {
    @Bean
    public AmqpItemWriter<Map<String, Object>> amqpItemWriter(AmqpTemplate amqpTemplate) {
        return new AmqpItemWriterBuilder().amqpTemplate(amqpTemplate).build();
    }

    @Bean
    public AmqpItemWriterProperties amqpItemWriterProperties() {
        return new AmqpItemWriterProperties();
    }

    @ConditionalOnProperty(name={"spring.batch.job.amqpitemwriter.jsonConverterEnabled"}, havingValue="true", matchIfMissing=true)
    @Bean
    public MessageConverter messageConverter() {
        return new Jackson2JsonMessageConverter();
    }
}

