/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin2;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.commons.util.IdUtils;
import org.springframework.cloud.sleuth.Log;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanAdjuster;
import org.springframework.cloud.sleuth.SpanReporter;
import org.springframework.cloud.sleuth.zipkin2.EndpointLocator;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.StringUtils;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.reporter.Reporter;

public class ZipkinSpanReporter
implements SpanReporter {
    private static final org.apache.commons.logging.Log log = LogFactory.getLog(ZipkinSpanReporter.class);
    private final Reporter<zipkin2.Span> reporter;
    private final Environment environment;
    private final List<SpanAdjuster> spanAdjusters;
    final EndpointLocator endpointLocator;

    public ZipkinSpanReporter(Reporter<zipkin2.Span> reporter, EndpointLocator endpointLocator, Environment environment, List<SpanAdjuster> spanAdjusters) {
        this.reporter = reporter;
        this.endpointLocator = endpointLocator;
        this.environment = environment;
        this.spanAdjusters = spanAdjusters;
    }

    zipkin2.Span convert(Span span) {
        Span convertedSpan = span;
        for (SpanAdjuster adjuster : this.spanAdjusters) {
            convertedSpan = adjuster.adjust(convertedSpan);
        }
        Span.Builder zipkinSpan = zipkin2.Span.newBuilder();
        zipkinSpan.localEndpoint(this.endpointLocator.local());
        this.processLogs(convertedSpan, zipkinSpan);
        this.addZipkinTags(zipkinSpan, convertedSpan);
        if (zipkinSpan.kind() != null && this.environment != null) {
            this.setInstanceIdIfPresent(zipkinSpan, "spring.instance_id");
        }
        zipkinSpan.shared(convertedSpan.isShared());
        zipkinSpan.timestamp(convertedSpan.getBegin() * 1000L);
        if (!convertedSpan.isRunning()) {
            zipkinSpan.duration(this.calculateDurationInMicros(convertedSpan));
        }
        zipkinSpan.traceId(convertedSpan.traceIdString());
        if (convertedSpan.getParents().size() > 0) {
            if (convertedSpan.getParents().size() > 1) {
                log.error((Object)("Zipkin doesn't support spans with multiple parents. Omitting other parents for " + convertedSpan));
            }
            zipkinSpan.parentId(Span.idToHex((long)((Long)convertedSpan.getParents().get(0))));
        }
        zipkinSpan.id(Span.idToHex((long)convertedSpan.getSpanId()));
        if (StringUtils.hasText((String)convertedSpan.getName())) {
            zipkinSpan.name(convertedSpan.getName());
        }
        return zipkinSpan.build();
    }

    void processLogs(Span span, Span.Builder zipkinSpan) {
        for (Log log : span.logs()) {
            String event = log.getEvent();
            long micros = log.getTimestamp() * 1000L;
            if (event.length() == 2) {
                if (event.equals("cs")) {
                    zipkinSpan.kind(Span.Kind.CLIENT);
                    continue;
                }
                if (event.equals("sr")) {
                    zipkinSpan.kind(Span.Kind.SERVER);
                    continue;
                }
                if (event.equals("ss")) {
                    zipkinSpan.kind(Span.Kind.SERVER);
                    continue;
                }
                if (event.equals("cr")) {
                    zipkinSpan.kind(Span.Kind.CLIENT);
                    continue;
                }
                if (event.equals("ms")) {
                    zipkinSpan.kind(Span.Kind.PRODUCER);
                    continue;
                }
                if (event.equals("mr")) {
                    zipkinSpan.kind(Span.Kind.CONSUMER);
                    continue;
                }
                zipkinSpan.addAnnotation(micros, event);
                continue;
            }
            zipkinSpan.addAnnotation(micros, event);
        }
    }

    private void setInstanceIdIfPresent(Span.Builder zipkinSpan, String key) {
        String property = this.defaultInstanceId();
        if (StringUtils.hasText((String)property)) {
            zipkinSpan.putTag(key, property);
        }
    }

    String defaultInstanceId() {
        return IdUtils.getDefaultInstanceId((PropertyResolver)this.environment);
    }

    private void addZipkinTags(Span.Builder zipkinSpan, Span span) {
        Endpoint.Builder remoteEndpoint = Endpoint.newBuilder();
        boolean shouldAddRemote = false;
        for (Map.Entry e : span.tags().entrySet()) {
            String key = (String)e.getKey();
            if (key.equals("peer.service")) {
                shouldAddRemote = true;
                remoteEndpoint.serviceName((String)e.getValue());
                continue;
            }
            if (key.equals("peer.ipv4") || key.equals("peer.ipv6")) {
                shouldAddRemote = true;
                remoteEndpoint.ip((String)e.getValue());
                continue;
            }
            if (key.equals("peer.port")) {
                shouldAddRemote = true;
                try {
                    remoteEndpoint.port(Integer.valueOf(Integer.parseInt((String)e.getValue())));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            zipkinSpan.putTag((String)e.getKey(), (String)e.getValue());
        }
        if (shouldAddRemote) {
            zipkinSpan.remoteEndpoint(remoteEndpoint.build());
        }
    }

    private long calculateDurationInMicros(Span span) {
        Log clientSend = this.hasLog("cs", span);
        Log clientReceived = this.hasLog("cr", span);
        if (clientSend != null && clientReceived != null) {
            return (clientReceived.getTimestamp() - clientSend.getTimestamp()) * 1000L;
        }
        return span.getAccumulatedMicros();
    }

    private Log hasLog(String logName, Span span) {
        for (Log log : span.logs()) {
            if (!logName.equals(log.getEvent())) continue;
            return log;
        }
        return null;
    }

    public void report(Span span) {
        if (span.isExportable()) {
            this.reporter.report((Object)this.convert(span));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("The span " + span + " will not be sent to Zipkin due to sampling"));
        }
    }

    public String toString() {
        return "ZipkinSpanReporter(" + this.reporter + ")";
    }
}

