/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.circuitbreaker;

import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.BDDAssertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JCircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.sleuth.ScopedSpan;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(classes={TestConfig.class})
public abstract class CircuitBreakerIntegrationTests {
    @Autowired
    TestSpanHandler spans;
    @Autowired
    Tracer tracer;
    @Autowired
    CircuitBreakerFactory factory;

    @BeforeEach
    public void setup() {
        this.spans.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_pass_tracing_information_when_using_circuit_breaker() {
        Tracer tracer = this.tracer;
        ScopedSpan scopedSpan = null;
        try {
            scopedSpan = tracer.startScopedSpan("start");
            Span span = (Span)this.factory.create("name").run(() -> ((Tracer)tracer).currentSpan());
            BDDAssertions.then((Object)span).isNotNull();
            BDDAssertions.then((String)scopedSpan.context().traceId()).isEqualTo(span.context().traceId());
        }
        finally {
            scopedSpan.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_pass_tracing_information_when_using_circuit_breaker_with_fallback() {
        Tracer tracer = this.tracer;
        AtomicReference first = new AtomicReference();
        AtomicReference second = new AtomicReference();
        ScopedSpan scopedSpan = null;
        try {
            scopedSpan = tracer.startScopedSpan("start");
            ((AbstractThrowableAssert)BDDAssertions.thenThrownBy(() -> this.factory.create("name").run(() -> {
                first.set(tracer.currentSpan());
                throw new IllegalStateException("boom");
            }, throwable -> {
                second.set(tracer.currentSpan());
                throw new IllegalStateException("boom2");
            })).isInstanceOf(IllegalStateException.class)).hasMessageContaining("boom2");
            BDDAssertions.then((Iterable)this.spans).hasSize(2);
            BDDAssertions.then((String)scopedSpan.context().traceId()).isEqualTo(((Span)first.get()).context().traceId());
            BDDAssertions.then((String)scopedSpan.context().traceId()).isEqualTo(((Span)second.get()).context().traceId());
            BDDAssertions.then((String)((Span)first.get()).context().spanId()).isNotEqualTo((Object)((Span)second.get()).context().spanId());
            FinishedSpan finishedSpan = this.spans.get(0);
            BDDAssertions.then((String)finishedSpan.getName()).contains(new CharSequence[]{"CircuitBreakerIntegrationTests"});
            this.assertException(finishedSpan);
            finishedSpan = this.spans.get(1);
            BDDAssertions.then((String)finishedSpan.getName()).contains(new CharSequence[]{"CircuitBreakerIntegrationTests"});
            this.assertException(finishedSpan);
        }
        finally {
            scopedSpan.end();
        }
    }

    public void assertException(FinishedSpan finishedSpan) {
        throw new UnsupportedOperationException("Implement this assertion");
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    public static class TestConfig {
        @Bean
        Resilience4JCircuitBreakerFactory resilience4JCircuitBreakerFactory() {
            return new Resilience4JCircuitBreakerFactory();
        }
    }
}

