/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import org.assertj.core.api.BDDAssertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ContextConfiguration(classes={TestConfig.class})
@TestPropertySource(properties={"management.endpoints.web.exposure.include:*"})
public abstract class SkipEndPointsIntegrationTestsWithoutContextPathWithBasePath {
    @LocalServerPort
    int port;
    @Autowired
    private TestSpanHandler spans;
    @Autowired
    private Tracer tracer;

    @BeforeEach
    @AfterEach
    public void clearSpans() {
        this.spans.clear();
    }

    @Test
    public void should_sample_non_actuator_endpoint() {
        new RestTemplate().getForObject("http://localhost:" + this.port + "/something", String.class, new Object[0]);
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
    }

    @Test
    public void should_sample_non_actuator_endpoint_and_healthcare_in_path() {
        new RestTemplate().getForObject("http://localhost:" + this.port + "/healthcare", String.class, new Object[0]);
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
    }

    @Test
    public void should_not_sample_actuator_endpoint() {
        new RestTemplate().getForObject("http://localhost:" + this.port + "/actuator/health", String.class, new Object[0]);
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        BDDAssertions.then((Iterable)this.spans).hasSize(0);
    }

    @Test
    public void should_not_sample_actuator_endpoint_with_parameter() {
        new RestTemplate().getForObject("http://localhost:" + this.port + "/actuator/metrics?xyz", String.class, new Object[0]);
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        BDDAssertions.then((Iterable)this.spans).hasSize(0);
    }

    @EnableAutoConfiguration
    @Configuration(proxyBeanMethods=false)
    @RestController
    public static class TestConfig {
        @GetMapping(value={"something"})
        void doNothing() {
        }

        @GetMapping(value={"healthcare"})
        void healthCare() {
        }

        @GetMapping(value={"metrics"})
        void metrics() {
        }
    }
}

