/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.ReadableSpan;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.otel.bridge.SpanFromSpanContext;
import org.springframework.lang.Nullable;

public class OtelTraceContext
implements TraceContext {
    final AtomicReference<Context> context;
    final SpanContext delegate;
    final Span span;

    OtelTraceContext(Context context, SpanContext delegate, @Nullable Span span) {
        this(new AtomicReference<Context>(context), delegate, span);
    }

    OtelTraceContext(AtomicReference<Context> context, SpanContext delegate, @Nullable Span span) {
        this.context = context;
        this.delegate = delegate;
        this.span = span;
    }

    OtelTraceContext(SpanContext delegate, @Nullable Span span) {
        this.context = new AtomicReference<Context>(Context.current());
        this.delegate = delegate;
        this.span = span;
    }

    OtelTraceContext(Span span) {
        this(Context.current(), span.getSpanContext(), span);
    }

    OtelTraceContext(SpanFromSpanContext span) {
        this(span.otelTraceContext.context.get(), span.getSpanContext(), (Span)span);
    }

    public static TraceContext fromOtel(SpanContext traceContext) {
        return new OtelTraceContext(traceContext, null);
    }

    public static Context toOtelContext(TraceContext context) {
        Span span;
        if (context instanceof OtelTraceContext && (span = ((OtelTraceContext)context).span) != null) {
            return span.storeInContext(Context.current());
        }
        return Context.current();
    }

    public String traceId() {
        return this.delegate.getTraceId();
    }

    @Nullable
    public String parentId() {
        if (this.span instanceof ReadableSpan) {
            ReadableSpan readableSpan = (ReadableSpan)this.span;
            return readableSpan.toSpanData().getParentSpanId();
        }
        return null;
    }

    public String spanId() {
        return this.delegate.getSpanId();
    }

    public Boolean sampled() {
        return this.delegate.isSampled();
    }

    public String toString() {
        return this.delegate != null ? this.delegate.toString() : "null";
    }

    Span span() {
        return this.span;
    }

    Context context() {
        return this.context.get();
    }

    void updateContext(Context context) {
        this.context.set(context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OtelTraceContext context = (OtelTraceContext)o;
        return Objects.equals(this.delegate, context.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }
}

