/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.otel.bridge.OtelSpan;

class OtelSpanInScope
implements Tracer.SpanInScope {
    private static final Log log = LogFactory.getLog(OtelSpanInScope.class);
    final Scope delegate;
    final OtelSpan sleuthSpan;
    final Span otelSpan;
    final SpanContext spanContext;

    OtelSpanInScope(OtelSpan sleuthSpan, Span otelSpan) {
        this.sleuthSpan = sleuthSpan;
        this.otelSpan = otelSpan;
        this.delegate = this.storedContext(otelSpan);
        this.spanContext = otelSpan.getSpanContext();
    }

    private Scope storedContext(Span otelSpan) {
        if (this.sleuthSpan == null || this.sleuthSpan.context() == null || this.sleuthSpan.context().context() == null) {
            return otelSpan.makeCurrent();
        }
        Context context = this.sleuthSpan.context().context();
        return context.with((ImplicitContextKeyed)otelSpan).makeCurrent();
    }

    public void close() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Will close scope for trace context [" + this.spanContext + "]"));
        }
        this.delegate.close();
    }
}

