/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.mongodb;

import com.mongodb.ContextProvider;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.SynchronousContextProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.autoconfigure.mongo.MongoClientSettingsBuilderCustomizer;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.mongodb.TraceRequestContext;

public class TraceSynchronousMongoClientSettingsBuilderCustomizer
implements MongoClientSettingsBuilderCustomizer {
    private final Tracer tracer;

    public TraceSynchronousMongoClientSettingsBuilderCustomizer(Tracer tracer) {
        this.tracer = tracer;
    }

    public void customize(MongoClientSettings.Builder clientSettingsBuilder) {
        clientSettingsBuilder.contextProvider((ContextProvider)TraceSynchronousMongoClientSettingsBuilderCustomizer.contextProvider(this.tracer));
    }

    static SynchronousContextProvider contextProvider(Tracer tracer) {
        return () -> new SynchronousTraceRequestContext(tracer);
    }

    static class SynchronousTraceRequestContext
    extends TraceRequestContext {
        SynchronousTraceRequestContext(Tracer tracer) {
            super(SynchronousTraceRequestContext.context(tracer));
        }

        private static Map<Object, Object> context(Tracer tracer) {
            ConcurrentHashMap<Object, Object> map = new ConcurrentHashMap<Object, Object>();
            Span currentSpan = tracer.currentSpan();
            if (currentSpan == null) {
                return map;
            }
            map.put(Span.class, currentSpan);
            map.put(TraceContext.class, currentSpan.context());
            return map;
        }
    }
}

