/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.jdbc;

import java.util.ArrayList;
import java.util.List;
import javax.sql.CommonDataSource;
import net.ttddyy.dsproxy.listener.MethodExecutionListener;
import net.ttddyy.dsproxy.listener.QueryCountStrategy;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.proxy.GlobalConnectionIdManager;
import net.ttddyy.dsproxy.proxy.ResultSetProxyLogicFactory;
import net.ttddyy.dsproxy.proxy.SimpleResultSetProxyLogicFactory;
import net.ttddyy.dsproxy.support.ProxyDataSource;
import net.ttddyy.dsproxy.transform.ParameterTransformer;
import net.ttddyy.dsproxy.transform.QueryTransformer;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.autoconfig.instrument.jdbc.TraceJdbcProperties;
import org.springframework.cloud.sleuth.instrument.jdbc.DataSourceNameResolver;
import org.springframework.cloud.sleuth.instrument.jdbc.DataSourceProxyBuilderCustomizer;
import org.springframework.cloud.sleuth.instrument.jdbc.DataSourceProxyConnectionIdManagerProvider;
import org.springframework.cloud.sleuth.instrument.jdbc.DataSourceProxyDataSourceDecorator;
import org.springframework.cloud.sleuth.instrument.jdbc.DataSourceProxyProperties;
import org.springframework.cloud.sleuth.instrument.jdbc.TraceListenerStrategySpanCustomizer;
import org.springframework.cloud.sleuth.instrument.jdbc.TraceQueryExecutionListener;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={ProxyDataSource.class})
@ConditionalOnProperty(name={"spring.sleuth.jdbc.datasource-proxy.enabled"}, havingValue="true", matchIfMissing=true)
class DataSourceProxyConfiguration {
    DataSourceProxyConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    DataSourceProxyConnectionIdManagerProvider traceConnectionIdManagerProvider() {
        return GlobalConnectionIdManager::new;
    }

    @Bean
    DataSourceProxyBuilderCustomizer proxyDataSourceBuilderConfigurer(ObjectProvider<QueryCountStrategy> queryCountStrategy, ObjectProvider<List<QueryExecutionListener>> listeners, ObjectProvider<List<MethodExecutionListener>> methodExecutionListeners, ObjectProvider<ParameterTransformer> parameterTransformer, ObjectProvider<QueryTransformer> queryTransformer, ObjectProvider<ResultSetProxyLogicFactory> resultSetProxyLogicFactory, ObjectProvider<DataSourceProxyConnectionIdManagerProvider> dataSourceProxyConnectionIdManagerProvider, TraceJdbcProperties traceJdbcProperties) {
        return new DataSourceProxyBuilderCustomizer((QueryCountStrategy)queryCountStrategy.getIfAvailable(() -> null), (List)listeners.getIfAvailable(() -> null), (List)methodExecutionListeners.getIfAvailable(() -> null), (ParameterTransformer)parameterTransformer.getIfAvailable(() -> null), (QueryTransformer)queryTransformer.getIfAvailable(() -> null), (ResultSetProxyLogicFactory)resultSetProxyLogicFactory.getIfAvailable(() -> null), (DataSourceProxyConnectionIdManagerProvider)dataSourceProxyConnectionIdManagerProvider.getIfAvailable(() -> null), this.props(traceJdbcProperties));
    }

    private DataSourceProxyProperties props(TraceJdbcProperties traceJdbcProperties) {
        TraceJdbcProperties.DataSourceProxyProperties originalProxy = traceJdbcProperties.getDatasourceProxy();
        DataSourceProxyProperties props = new DataSourceProxyProperties();
        BeanUtils.copyProperties((Object)originalProxy, (Object)props);
        props.setLogging(DataSourceProxyProperties.DataSourceProxyLogging.valueOf((String)originalProxy.getLogging().name()));
        BeanUtils.copyProperties((Object)originalProxy.getQuery(), (Object)props.getQuery());
        BeanUtils.copyProperties((Object)originalProxy.getSlowQuery(), (Object)props.getSlowQuery());
        return props;
    }

    @Bean
    DataSourceProxyDataSourceDecorator proxyDataSourceDecorator(DataSourceProxyBuilderCustomizer dataSourceProxyBuilderCustomizer, DataSourceNameResolver dataSourceNameResolver) {
        return new DataSourceProxyDataSourceDecorator(dataSourceProxyBuilderCustomizer, dataSourceNameResolver);
    }

    @Bean
    TraceQueryExecutionListener traceQueryExecutionListener(BeanFactory beanFactory, TraceJdbcProperties dataSourceDecoratorProperties, ObjectProvider<List<TraceListenerStrategySpanCustomizer<? super CommonDataSource>>> customizers) {
        return new TraceQueryExecutionListener(beanFactory, dataSourceDecoratorProperties.getIncludes(), (List)customizers.getIfAvailable(ArrayList::new));
    }

    @Bean
    @ConditionalOnMissingBean
    ResultSetProxyLogicFactory traceResultSetProxyLogicFactory() {
        return new SimpleResultSetProxyLogicFactory();
    }
}

