/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.proxy;

import com.netflix.zuul.ZuulFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.netflix.zuul.filters.ProxyRequestHelper;
import org.springframework.cloud.security.oauth2.proxy.AuthenticationHeaderFilter;
import org.springframework.cloud.security.oauth2.proxy.OAuth2TokenRelayFilter;
import org.springframework.cloud.security.oauth2.proxy.ProxyAuthenticationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ZuulFilter.class, EnableOAuth2Client.class, SecurityProperties.class})
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={ProxyAuthenticationProperties.class})
public class OAuth2ProxyAutoConfiguration {
    @Autowired
    private ProxyAuthenticationProperties properties;
    @Autowired(required=false)
    private OAuth2RestOperations restTemplate;
    @Autowired(required=false)
    @LoadBalanced
    private OAuth2RestOperations loadBalancedRestTemplate;

    @Bean
    public OAuth2TokenRelayFilter oauth2TokenRelayFilter() {
        OAuth2TokenRelayFilter filter = new OAuth2TokenRelayFilter(this.properties);
        if (this.loadBalancedRestTemplate != null && this.properties.isLoadBalanced()) {
            filter.setRestTemplate(this.loadBalancedRestTemplate);
        } else if (this.restTemplate != null) {
            filter.setRestTemplate(this.restTemplate);
        }
        return filter;
    }

    @ConditionalOnClass(value={ProxyRequestHelper.class})
    @Configuration(proxyBeanMethods=false)
    protected static class AuthenticationHeaderFilterConfiguration {
        protected AuthenticationHeaderFilterConfiguration() {
        }

        @Bean
        public AuthenticationHeaderFilter authenticationHeaderFilter(ProxyAuthenticationProperties properties) {
            ProxyRequestHelper helper = new ProxyRequestHelper();
            return new AuthenticationHeaderFilter(helper, properties);
        }
    }
}

