/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.gateway;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.security.oauth2.gateway.TokenRelayGatewayFilterFactory;
import org.springframework.cloud.security.oauth2.proxy.ProxyAuthenticationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.security.web.server.SecurityWebFilterChain;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"spring.cloud.gateway.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={GatewayFilter.class, OAuth2AuthorizedClient.class, SecurityWebFilterChain.class, SecurityProperties.class})
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={ProxyAuthenticationProperties.class})
public class TokenRelayAutoConfiguration {
    @Bean
    public TokenRelayGatewayFilterFactory tokenRelayGatewayFilterFactory(ServerOAuth2AuthorizedClientRepository repository) {
        return new TokenRelayGatewayFilterFactory(repository);
    }
}

