/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.resource;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.UserProfile;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.social.oauth2.AccessGrant;

public class SpringSocialTokenServices
implements ResourceServerTokenServices {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private OAuth2ConnectionFactory<?> connectionFactory;
    private String clientId;

    public SpringSocialTokenServices(OAuth2ConnectionFactory<?> connectionFactory, String clientId) {
        this.connectionFactory = connectionFactory;
        this.clientId = clientId;
    }

    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException, InvalidTokenException {
        Connection connection = this.connectionFactory.createConnection(new AccessGrant(accessToken));
        UserProfile user = connection.fetchUserProfile();
        return this.extractAuthentication(user);
    }

    private OAuth2Authentication extractAuthentication(UserProfile user) {
        UsernamePasswordAuthenticationToken principal = new UsernamePasswordAuthenticationToken((Object)user.getUsername(), (Object)"N/A", (Collection)AuthorityUtils.commaSeparatedStringToAuthorityList((String)"ROLE_USER"));
        principal.setDetails((Object)user);
        OAuth2Request request = new OAuth2Request(null, this.clientId, null, true, null, null, null, null, null);
        return new OAuth2Authentication(request, (Authentication)principal);
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        throw new UnsupportedOperationException("Not supported: read access token");
    }
}

