/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.scheduler.spi.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.deployer.resource.maven.MavenProperties;
import org.springframework.cloud.deployer.resource.maven.MavenResource;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.cloud.scheduler.spi.core.CreateScheduleException;
import org.springframework.cloud.scheduler.spi.core.ScheduleInfo;
import org.springframework.cloud.scheduler.spi.core.ScheduleRequest;
import org.springframework.cloud.scheduler.spi.core.Scheduler;
import org.springframework.cloud.scheduler.spi.core.SchedulerException;
import org.springframework.cloud.scheduler.spi.test.EventuallyMatcher;
import org.springframework.cloud.scheduler.spi.test.Timeout;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.NONE)
@ContextConfiguration(classes={Config.class})
public abstract class AbstractIntegrationTests {
    @Autowired
    protected MavenProperties mavenProperties;
    private SchedulerWrapper schedulerWrapper;
    private Timeout scheduleTimeout = new Timeout(12, 5000);
    private Timeout unScheduleTimeout = new Timeout(12, 5000);
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Rule
    public TestName name = new TestName();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @After
    public void tearDown() {
        ArrayList<ScheduleRequest> scheduleRequests = new ArrayList<ScheduleRequest>(this.schedulerWrapper.getScheduledTasks().values());
        for (ScheduleRequest scheduleRequest : scheduleRequests) {
            this.unscheduleTestSchedule(scheduleRequest.getScheduleName());
        }
    }

    protected Scheduler taskScheduler() {
        return this.schedulerWrapper;
    }

    protected abstract Scheduler provideScheduler();

    protected abstract List<String> getCommandLineArgs();

    protected abstract Map<String, String> getSchedulerProperties();

    protected abstract Map<String, String> getDeploymentProperties();

    protected abstract Map<String, String> getAppProperties();

    @Before
    public void wrapScheduler() {
        this.schedulerWrapper = new SchedulerWrapper(this.provideScheduler());
    }

    @Test
    public void testSimpleSchedule() {
        this.createAndVerifySchedule();
    }

    @Test
    public void testUnschedule() {
        int initialSize = this.taskScheduler().list().size();
        ScheduleInfo scheduleInfo = this.createAndVerifySchedule();
        this.unscheduleTestSchedule(scheduleInfo.getScheduleName());
        Assert.assertEquals((long)0L, (long)(this.taskScheduler().list().size() - initialSize));
    }

    @Test
    public void testDuplicateSchedule() {
        ScheduleRequest request = this.createScheduleRequest();
        this.taskScheduler().schedule(request);
        ScheduleInfo scheduleInfo = new ScheduleInfo();
        scheduleInfo.setScheduleName(request.getScheduleName());
        this.expectedException.expect(CreateScheduleException.class);
        this.expectedException.expectMessage(String.format("Failed to create schedule %s", request.getScheduleName()));
        this.verifySchedule(scheduleInfo);
        this.taskScheduler().schedule(request);
    }

    @Test
    public void testUnScheduleNoEntry() {
        String definitionName = this.randomName();
        String scheduleName = "ScheduleName_" + definitionName;
        this.expectedException.expect(SchedulerException.class);
        this.expectedException.expectMessage(String.format("Failed to unschedule schedule %s does not exist.", scheduleName));
        this.unscheduleTestSchedule(scheduleName);
    }

    @Test
    public void testMultipleSchedule() {
        String definitionName = this.randomName();
        String scheduleName = "Schedule_Name " + definitionName;
        for (int i = 0; i < 4; ++i) {
            ScheduleRequest request = this.createScheduleRequest(scheduleName + i, definitionName + i);
            this.taskScheduler().schedule(request);
        }
        List scheduleInfos = this.taskScheduler().list();
        for (ScheduleInfo scheduleInfo : scheduleInfos) {
            this.verifySchedule(scheduleInfo);
        }
    }

    @Test
    public void testListFilter() {
        String definitionName = this.randomName();
        String scheduleName = "Schedule_Name " + definitionName;
        for (int i = 0; i < 4; ++i) {
            ScheduleRequest request = this.createScheduleRequest(scheduleName + i, definitionName + i % 2);
            this.taskScheduler().schedule(request);
        }
        ScheduleInfo scheduleInfo = new ScheduleInfo();
        scheduleInfo.setScheduleName(scheduleName + 0);
        scheduleInfo.setTaskDefinitionName(definitionName + 0);
        Assert.assertThat((Object)scheduleInfo, EventuallyMatcher.eventually(this.hasSpecifiedSchedulesByTaskDefinitionName(this.taskScheduler().list(definitionName + 0), scheduleInfo.getTaskDefinitionName(), 2), this.scheduleTimeout.maxAttempts, this.scheduleTimeout.pause));
    }

    public Timeout getScheduleTimeout() {
        return this.scheduleTimeout;
    }

    public void setScheduleTimeout(Timeout scheduleTimeout) {
        this.scheduleTimeout = scheduleTimeout;
    }

    public Timeout getUnScheduleTimeout() {
        return this.unScheduleTimeout;
    }

    public void setUnScheduleTimeout(Timeout unScheduleTimeout) {
        this.unScheduleTimeout = unScheduleTimeout;
    }

    private ScheduleInfo createAndVerifySchedule() {
        ScheduleRequest request = this.createScheduleRequest();
        this.taskScheduler().schedule(request);
        ScheduleInfo scheduleInfo = new ScheduleInfo();
        scheduleInfo.setScheduleName(request.getScheduleName());
        this.verifySchedule(scheduleInfo);
        return scheduleInfo;
    }

    private ScheduleRequest createScheduleRequest() {
        String definitionName = this.randomName();
        String scheduleName = "ScheduleName_" + definitionName;
        return this.createScheduleRequest(scheduleName, definitionName);
    }

    private ScheduleRequest createScheduleRequest(String scheduleName, String definitionName) {
        AppDefinition definition = new AppDefinition(definitionName, this.getAppProperties());
        return new ScheduleRequest(definition, this.getSchedulerProperties(), this.getDeploymentProperties(), this.getCommandLineArgs(), scheduleName, this.testApplication());
    }

    private void verifySchedule(ScheduleInfo scheduleInfo) {
        Assert.assertThat((Object)scheduleInfo, EventuallyMatcher.eventually(this.hasSpecifiedSchedule(this.taskScheduler().list(), scheduleInfo.getScheduleName()), this.scheduleTimeout.maxAttempts, this.scheduleTimeout.pause));
    }

    private void unscheduleTestSchedule(String scheduleName) {
        this.log.info("unscheduling {}...", (Object)scheduleName);
        this.taskScheduler().unschedule(scheduleName);
        ScheduleInfo scheduleInfo = new ScheduleInfo();
        scheduleInfo.setScheduleName(scheduleName);
        Assert.assertThat((Object)scheduleInfo, EventuallyMatcher.eventually(this.specifiedScheduleNotPresent(this.taskScheduler().list(), scheduleName), this.unScheduleTimeout.maxAttempts, this.unScheduleTimeout.pause));
    }

    protected String randomName() {
        return this.name.getMethodName() + "-" + UUID.randomUUID().toString();
    }

    protected Matcher<ScheduleInfo> hasSpecifiedSchedule(final List<ScheduleInfo> schedules, final String scheduleName) {
        return new BaseMatcher<ScheduleInfo>(){

            public boolean matches(Object item) {
                boolean result = false;
                for (ScheduleInfo scheduleInfo : schedules) {
                    if (!scheduleInfo.getScheduleName().equals(scheduleName)) continue;
                    result = true;
                    break;
                }
                return result;
            }

            public void describeMismatch(Object item, Description mismatchDescription) {
                mismatchDescription.appendText("unable to find specified scheduleName ").appendValue(item).appendText(" ");
            }

            public void describeTo(Description description) {
                description.appendText("unable to find specified scheduleName ");
            }
        };
    }

    protected Matcher<ScheduleInfo> hasSpecifiedSchedulesByTaskDefinitionName(final List<ScheduleInfo> schedules, final String taskDefinitionName, final int expectedScheduleCount) {
        return new BaseMatcher<ScheduleInfo>(){

            public boolean matches(Object item) {
                boolean result = false;
                if (schedules.size() == expectedScheduleCount) {
                    for (ScheduleInfo scheduleInfo : schedules) {
                        if (!scheduleInfo.getTaskDefinitionName().equals(taskDefinitionName)) continue;
                        result = true;
                        break;
                    }
                }
                return result;
            }

            public void describeMismatch(Object item, Description mismatchDescription) {
                mismatchDescription.appendText("unable to find specified taskDefinitionName ").appendValue(item).appendText(" ");
            }

            public void describeTo(Description description) {
                description.appendText("unable to find specified taskDefinitionName ");
            }
        };
    }

    protected Matcher<ScheduleInfo> specifiedScheduleNotPresent(final List<ScheduleInfo> schedules, final String scheduleName) {
        return new BaseMatcher<ScheduleInfo>(){

            public boolean matches(Object item) {
                boolean result = true;
                for (ScheduleInfo schedule : schedules) {
                    if (!schedule.getScheduleName().equals(scheduleName)) continue;
                    result = false;
                    break;
                }
                return result;
            }

            public void describeMismatch(Object item, Description mismatchDescription) {
                mismatchDescription.appendText("unable to find specified scheduleName ").appendValue(item).appendText(" ");
            }

            public void describeTo(Description description) {
                description.appendText("unable to find specified scheduleName ");
            }
        };
    }

    protected Resource testApplication() {
        Properties properties = new Properties();
        try {
            properties.load(new ClassPathResource("integration-test-app.properties").getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to determine which version of spring-cloud-scheduler-spi-test-app to use", e);
        }
        return new MavenResource.Builder(this.mavenProperties).groupId("org.springframework.cloud").artifactId("spring-cloud-scheduler-spi-test-app").classifier("exec").version(properties.getProperty("version")).extension("jar").build();
    }

    @Configuration
    public static class Config {
        @Bean
        @ConfigurationProperties(value="maven")
        public MavenProperties mavenProperties() {
            return new MavenProperties();
        }
    }

    protected static class SchedulerWrapper
    implements Scheduler {
        private final Scheduler wrapped;
        private final Map<String, ScheduleRequest> scheduledTasks = new HashMap<String, ScheduleRequest>();

        public SchedulerWrapper(Scheduler wrapped) {
            this.wrapped = wrapped;
        }

        public void schedule(ScheduleRequest scheduleRequest) {
            this.wrapped.schedule(scheduleRequest);
            this.scheduledTasks.put(scheduleRequest.getScheduleName(), scheduleRequest);
        }

        public void unschedule(String scheduleName) {
            this.wrapped.unschedule(scheduleName);
            this.scheduledTasks.remove(scheduleName);
        }

        public List<ScheduleInfo> list(String taskDefinitionName) {
            return this.wrapped.list(taskDefinitionName);
        }

        public List<ScheduleInfo> list() {
            return this.wrapped.list();
        }

        public Map<String, ScheduleRequest> getScheduledTasks() {
            return Collections.unmodifiableMap(this.scheduledTasks);
        }
    }
}

