/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.servicebroker.autoconfigure.web.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cloud.servicebroker.exception.ServiceBrokerApiVersionException;
import org.springframework.cloud.servicebroker.exception.ServiceBrokerApiVersionMissingException;
import org.springframework.cloud.servicebroker.model.BrokerApiVersion;
import org.springframework.web.servlet.HandlerInterceptor;

public class ApiVersionInterceptor
implements HandlerInterceptor {
    private final BrokerApiVersion version;

    public ApiVersionInterceptor() {
        this(null);
    }

    public ApiVersionInterceptor(BrokerApiVersion version) {
        this.version = version;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (this.version != null && !this.anyVersionAllowed()) {
            String apiVersion = request.getHeader(this.version.getBrokerApiVersionHeader());
            if (apiVersion == null) {
                throw new ServiceBrokerApiVersionMissingException(this.version.getApiVersion());
            }
            if (!this.version.getApiVersion().equals(apiVersion)) {
                throw new ServiceBrokerApiVersionException(this.version.getApiVersion(), apiVersion);
            }
        }
        return true;
    }

    private boolean anyVersionAllowed() {
        return "*".equals(this.version.getApiVersion());
    }
}

