/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.servicebroker.autoconfigure.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotEmpty;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.cloud.servicebroker.autoconfigure.web.DashboardClient;
import org.springframework.cloud.servicebroker.autoconfigure.web.Plan;

public class ServiceDefinition {
    @NotEmpty
    private String id;
    @NotEmpty
    private String name;
    @NotEmpty
    private String description;
    private Boolean bindable = false;
    private Boolean planUpdateable;
    private Boolean instancesRetrievable;
    private Boolean bindingsRetrievable;
    private final List<String> tags = new ArrayList<String>();
    private final Map<String, Object> metadata = new HashMap<String, Object>();
    private final List<String> requires = new ArrayList<String>();
    @NestedConfigurationProperty
    private DashboardClient dashboardClient;
    @NestedConfigurationProperty
    @NotEmpty
    private final List<Plan> plans = new ArrayList<Plan>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean isBindable() {
        return this.bindable;
    }

    public void setBindable(Boolean bindable) {
        this.bindable = bindable;
    }

    public Boolean isPlanUpdateable() {
        return this.planUpdateable;
    }

    public void setPlanUpdateable(Boolean planUpdateable) {
        this.planUpdateable = planUpdateable;
    }

    public Boolean isInstancesRetrievable() {
        return this.instancesRetrievable;
    }

    public void setInstancesRetrievable(Boolean instancesRetrievable) {
        this.instancesRetrievable = instancesRetrievable;
    }

    public Boolean isBindingsRetrievable() {
        return this.bindingsRetrievable;
    }

    public void setBindingsRetrievable(Boolean bindingsRetrievable) {
        this.bindingsRetrievable = bindingsRetrievable;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public List<String> getRequires() {
        return this.requires;
    }

    public DashboardClient getDashboardClient() {
        return this.dashboardClient;
    }

    public void setDashboardClient(DashboardClient dashboardClient) {
        this.dashboardClient = dashboardClient;
    }

    public List<Plan> getPlans() {
        return this.plans;
    }

    public org.springframework.cloud.servicebroker.model.catalog.ServiceDefinition toModel() {
        List modelPlans = this.plans.stream().map(Plan::toModel).collect(Collectors.toList());
        return org.springframework.cloud.servicebroker.model.catalog.ServiceDefinition.builder().id(this.id).name(this.name).description(this.description).bindable(this.bindable.booleanValue()).planUpdateable(this.planUpdateable).instancesRetrievable(this.instancesRetrievable).bindingsRetrievable(this.bindingsRetrievable).tags(this.tags).metadata(this.metadata).requires(this.requires).dashboardClient(this.dashboardClient == null ? null : this.dashboardClient.toModel()).plans(modelPlans).build();
    }
}

