/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.route;

import com.netflix.client.http.HttpRequest;
import com.netflix.niws.client.http.RestClient;
import java.util.Collections;
import java.util.Set;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.netflix.ribbon.support.RibbonCommandContext;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.netflix.zuul.filters.route.FallbackProvider;
import org.springframework.cloud.netflix.zuul.filters.route.RestClientRibbonCommand;
import org.springframework.cloud.netflix.zuul.filters.route.support.AbstractRibbonCommandFactory;

public class RestClientRibbonCommandFactory
extends AbstractRibbonCommandFactory {
    private SpringClientFactory clientFactory;
    private ZuulProperties zuulProperties;

    public RestClientRibbonCommandFactory(SpringClientFactory clientFactory) {
        this(clientFactory, new ZuulProperties(), Collections.emptySet());
    }

    public RestClientRibbonCommandFactory(SpringClientFactory clientFactory, ZuulProperties zuulProperties, Set<FallbackProvider> zuulFallbackProviders) {
        super(zuulFallbackProviders);
        this.clientFactory = clientFactory;
        this.zuulProperties = zuulProperties;
    }

    public RestClientRibbonCommand create(RibbonCommandContext context) {
        String serviceId = context.getServiceId();
        FallbackProvider fallbackProvider = this.getFallbackProvider(serviceId);
        RestClient restClient = (RestClient)this.clientFactory.getClient(serviceId, RestClient.class);
        return new RestClientRibbonCommand(context.getServiceId(), restClient, context, this.zuulProperties, fallbackProvider, this.clientFactory.getClientConfig(serviceId));
    }

    public SpringClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public void setZuulProperties(ZuulProperties zuulProperties) {
        this.zuulProperties = zuulProperties;
    }

    protected static HttpRequest.Verb getVerb(String method) {
        return RestClientRibbonCommand.getVerb(method);
    }
}

