/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.cloud.netflix.zuul.RoutesRefreshedEvent;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

@Endpoint(id="routes")
public class RoutesEndpoint
implements ApplicationEventPublisherAware {
    static final String ID = "routes";
    static final String FORMAT_DETAILS = "details";
    private RouteLocator routes;
    private ApplicationEventPublisher publisher;

    public RoutesEndpoint(RouteLocator routes) {
        this.routes = routes;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @ReadOperation
    public Map<String, String> invoke() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Route route : this.routes.getRoutes()) {
            map.put(route.getFullPath(), route.getLocation());
        }
        return map;
    }

    Map<String, RouteDetails> invokeRouteDetails() {
        LinkedHashMap<String, RouteDetails> map = new LinkedHashMap<String, RouteDetails>();
        for (Route route : this.routes.getRoutes()) {
            map.put(route.getFullPath(), new RouteDetails(route));
        }
        return map;
    }

    @WriteOperation
    public Object reset() {
        this.publisher.publishEvent((ApplicationEvent)new RoutesRefreshedEvent(this.routes));
        return this.invoke();
    }

    @ReadOperation
    public Object invokeRouteDetails(@Selector String format) {
        if (FORMAT_DETAILS.equalsIgnoreCase(format)) {
            return this.invokeRouteDetails();
        }
        return this.invoke();
    }

    @JsonPropertyOrder(value={"id", "fullPath", "location"})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class RouteDetails {
        private String id;
        private String fullPath;
        private String path;
        private String location;
        private String prefix;
        private Boolean retryable;
        private Set<String> sensitiveHeaders;
        private boolean customSensitiveHeaders;
        private boolean prefixStripped;

        public RouteDetails() {
        }

        RouteDetails(Route route) {
            this.id = route.getId();
            this.fullPath = route.getFullPath();
            this.path = route.getPath();
            this.location = route.getLocation();
            this.prefix = route.getPrefix();
            this.retryable = route.getRetryable();
            this.sensitiveHeaders = route.getSensitiveHeaders();
            this.customSensitiveHeaders = route.isCustomSensitiveHeaders();
            this.prefixStripped = route.isPrefixStripped();
        }

        public String getId() {
            return this.id;
        }

        public String getFullPath() {
            return this.fullPath;
        }

        public String getPath() {
            return this.path;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Boolean getRetryable() {
            return this.retryable;
        }

        public Set<String> getSensitiveHeaders() {
            return this.sensitiveHeaders;
        }

        public boolean isCustomSensitiveHeaders() {
            return this.customSensitiveHeaders;
        }

        public boolean isPrefixStripped() {
            return this.prefixStripped;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RouteDetails that = (RouteDetails)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.fullPath, that.fullPath) && Objects.equals(this.path, that.path) && Objects.equals(this.location, that.location) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.retryable, that.retryable) && Objects.equals(this.sensitiveHeaders, that.sensitiveHeaders) && this.customSensitiveHeaders == that.customSensitiveHeaders && this.prefixStripped == that.prefixStripped;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.fullPath, this.path, this.location, this.prefix, this.retryable, this.sensitiveHeaders, this.customSensitiveHeaders, this.prefixStripped);
        }
    }
}

