/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.filters.FilterRegistry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="filters")
public class FiltersEndpoint {
    private final FilterRegistry filterRegistry;

    public FiltersEndpoint(FilterRegistry filterRegistry) {
        this.filterRegistry = filterRegistry;
    }

    @ReadOperation
    public Map<String, List<Map<String, Object>>> invoke() {
        TreeMap<String, List<Map<String, Object>>> filterMap = new TreeMap<String, List<Map<String, Object>>>();
        for (ZuulFilter filter : this.filterRegistry.getAllFilters()) {
            if (!filterMap.containsKey(filter.filterType())) {
                filterMap.put(filter.filterType(), new ArrayList());
            }
            LinkedHashMap<String, Object> filterInfo = new LinkedHashMap<String, Object>();
            filterInfo.put("class", filter.getClass().getName());
            filterInfo.put("order", filter.filterOrder());
            filterInfo.put("disabled", filter.isFilterDisabled());
            filterInfo.put("static", filter.isStaticFilter());
            ((List)filterMap.get(filter.filterType())).add(filterInfo);
        }
        return filterMap;
    }
}

