/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.route.okhttp;

import java.util.Collections;
import java.util.Set;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.netflix.ribbon.okhttp.OkHttpLoadBalancingClient;
import org.springframework.cloud.netflix.ribbon.support.RibbonCommandContext;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.netflix.zuul.filters.route.FallbackProvider;
import org.springframework.cloud.netflix.zuul.filters.route.okhttp.OkHttpRibbonCommand;
import org.springframework.cloud.netflix.zuul.filters.route.support.AbstractRibbonCommandFactory;

public class OkHttpRibbonCommandFactory
extends AbstractRibbonCommandFactory {
    private SpringClientFactory clientFactory;
    private ZuulProperties zuulProperties;

    public OkHttpRibbonCommandFactory(SpringClientFactory clientFactory, ZuulProperties zuulProperties) {
        this(clientFactory, zuulProperties, Collections.emptySet());
    }

    public OkHttpRibbonCommandFactory(SpringClientFactory clientFactory, ZuulProperties zuulProperties, Set<FallbackProvider> zuulFallbackProviders) {
        super(zuulFallbackProviders);
        this.clientFactory = clientFactory;
        this.zuulProperties = zuulProperties;
    }

    public OkHttpRibbonCommand create(RibbonCommandContext context) {
        String serviceId = context.getServiceId();
        FallbackProvider fallbackProvider = this.getFallbackProvider(serviceId);
        OkHttpLoadBalancingClient client = (OkHttpLoadBalancingClient)this.clientFactory.getClient(serviceId, OkHttpLoadBalancingClient.class);
        client.setLoadBalancer(this.clientFactory.getLoadBalancer(serviceId));
        return new OkHttpRibbonCommand(serviceId, client, context, this.zuulProperties, fallbackProvider, this.clientFactory.getClientConfig(serviceId));
    }
}

