/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.turbine.stream;

import java.util.Objects;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="turbine.stream")
public class TurbineStreamProperties {
    @Value(value="${server.port:8989}")
    private int port = 8989;
    private String destination = "springCloudHystrixStream";
    private String contentType = "application/json";

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TurbineStreamProperties that = (TurbineStreamProperties)o;
        return this.port == that.port && Objects.equals(this.destination, that.destination) && Objects.equals(this.contentType, that.contentType);
    }

    public int hashCode() {
        return Objects.hash(this.port, this.destination, this.contentType);
    }

    public String toString() {
        return "TurbineStreamProperties{" + "port=" + this.port + ", " + "destination='" + this.destination + "', " + "contentType='" + this.contentType + "'}";
    }
}

