/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.hystrix.dashboard;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.WebRequest;

@Controller
public class HystrixDashboardController {
    @RequestMapping(value={"/hystrix"})
    public String home(Model model, WebRequest request) {
        model.addAttribute("basePath", (Object)this.extractPath(request));
        return "hystrix/index";
    }

    @RequestMapping(value={"/hystrix/{path}"})
    public String monitor(@PathVariable String path, Model model, WebRequest request) {
        model.addAttribute("basePath", (Object)this.extractPath(request));
        model.addAttribute("contextPath", (Object)request.getContextPath());
        return "hystrix/" + path;
    }

    private String extractPath(WebRequest request) {
        String path = String.valueOf(request.getContextPath()) + request.getAttribute("org.springframework.web.servlet.HandlerMapping.pathWithinHandlerMapping", 0);
        return path;
    }
}

