/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discoveryclient.it;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.kubernetes.commons.discovery.EndpointNameAndNamespace;
import org.springframework.context.ApplicationListener;
import org.springframework.core.log.LogAccessor;
import org.springframework.stereotype.Component;

@Component
class HeartbeatListener
implements ApplicationListener<HeartbeatEvent> {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(HeartbeatListener.class));
    public final AtomicReference<List<EndpointNameAndNamespace>> state = new AtomicReference(List.of());

    HeartbeatListener() {
    }

    public void onApplicationEvent(HeartbeatEvent event) {
        LOG.info((CharSequence)"received heartbeat event in listener");
        List state = (List)event.getValue();
        this.state.set(state);
        LOG.info((CharSequence)("state received : " + String.valueOf(state)));
    }
}

