/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.loadbalancer;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.loadbalancer.KubernetesServiceInstanceMapper;
import org.springframework.cloud.kubernetes.commons.loadbalancer.KubernetesServicesListSupplier;
import org.springframework.cloud.kubernetes.fabric8.Fabric8Utils;
import org.springframework.cloud.kubernetes.fabric8.loadbalancer.Fabric8ServiceInstanceMapper;
import org.springframework.core.env.Environment;
import org.springframework.core.log.LogAccessor;
import reactor.core.publisher.Flux;

public class Fabric8ServicesListSupplier
extends KubernetesServicesListSupplier<Service> {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(Fabric8ServicesListSupplier.class));
    private final KubernetesClient kubernetesClient;
    private final KubernetesNamespaceProvider namespaceProvider;

    Fabric8ServicesListSupplier(Environment environment, KubernetesClient kubernetesClient, Fabric8ServiceInstanceMapper mapper, KubernetesDiscoveryProperties discoveryProperties) {
        super(environment, (KubernetesServiceInstanceMapper)mapper, discoveryProperties);
        this.kubernetesClient = kubernetesClient;
        this.namespaceProvider = new KubernetesNamespaceProvider(environment);
    }

    public Flux<List<ServiceInstance>> get() {
        ArrayList<ServiceInstance> result = new ArrayList<ServiceInstance>();
        String serviceName = this.getServiceId();
        LOG.debug(() -> "serviceID : " + serviceName);
        if (this.discoveryProperties.allNamespaces()) {
            LOG.debug(() -> "discovering services in all namespaces");
            List services = ((ServiceList)((FilterWatchListDeletable)((AnyNamespaceOperation)this.kubernetesClient.services().inAnyNamespace()).withField("metadata.name", serviceName)).list()).getItems();
            services.forEach(service -> this.addMappedService((KubernetesServiceInstanceMapper<Service>)this.mapper, (List<ServiceInstance>)result, (Service)service));
        } else if (!this.discoveryProperties.namespaces().isEmpty()) {
            List selectiveNamespaces = this.discoveryProperties.namespaces().stream().sorted().toList();
            LOG.debug(() -> "discovering services in selective namespaces : " + selectiveNamespaces);
            selectiveNamespaces.forEach(selectiveNamespace -> {
                Service service = (Service)((ServiceResource)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(selectiveNamespace)).withName(serviceName)).get();
                if (service != null) {
                    this.addMappedService((KubernetesServiceInstanceMapper<Service>)this.mapper, result, service);
                } else {
                    LOG.debug(() -> "did not find service with name : " + serviceName + " in namespace : " + selectiveNamespace);
                }
            });
        } else {
            String namespace = Fabric8Utils.getApplicationNamespace((KubernetesClient)this.kubernetesClient, null, (String)"loadbalancer-service", (KubernetesNamespaceProvider)this.namespaceProvider);
            LOG.debug(() -> "discovering services in namespace : " + namespace);
            Service service2 = (Service)((ServiceResource)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).withName(serviceName)).get();
            if (service2 != null) {
                this.addMappedService((KubernetesServiceInstanceMapper<Service>)this.mapper, result, service2);
            } else {
                LOG.debug(() -> "did not find service with name : " + serviceName + " in namespace : " + namespace);
            }
        }
        LOG.debug(() -> "found services : " + result);
        return Flux.just(result);
    }

    private void addMappedService(KubernetesServiceInstanceMapper<Service> mapper, List<ServiceInstance> services, Service service) {
        services.add((ServiceInstance)mapper.map((Object)service));
    }
}

