/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.api.model.Service;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryPropertiesAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnBlockingOrReactiveDiscoveryEnabled;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
@ConditionalOnBlockingOrReactiveDiscoveryEnabled
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@AutoConfigureAfter(value={KubernetesDiscoveryPropertiesAutoConfiguration.class})
final class Fabric8DiscoveryClientSpelAutoConfiguration {
    Fabric8DiscoveryClientSpelAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    Predicate<Service> predicate(KubernetesDiscoveryProperties properties) {
        Predicate<Service> predicate;
        SpelExpressionParser parser = new SpelExpressionParser();
        SimpleEvaluationContext evaluationContext = SimpleEvaluationContext.forReadOnlyDataBinding().withInstanceMethods().build();
        String spelExpression = properties.filter();
        if (spelExpression == null || spelExpression.isEmpty()) {
            predicate = service -> true;
        } else {
            Expression filterExpr = parser.parseExpression(spelExpression);
            predicate = service -> {
                Boolean include = (Boolean)filterExpr.getValue((EvaluationContext)evaluationContext, service, Boolean.class);
                return Optional.ofNullable(include).orElse(false);
            };
        }
        return predicate;
    }
}

