/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import org.springframework.boot.bootstrap.BootstrapContext;
import org.springframework.boot.bootstrap.BootstrapRegistry;
import org.springframework.cloud.config.client.ConfigServerConfigDataLocationResolver;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.KubernetesConfigServerBootstrapper;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.ServicePortSecureResolver;
import org.springframework.cloud.kubernetes.fabric8.Fabric8AutoConfiguration;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8DiscoveryClient;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8DiscoveryClientSpelAutoConfiguration;

final class Fabric8ConfigServerBootstrapper
extends KubernetesConfigServerBootstrapper {
    Fabric8ConfigServerBootstrapper() {
    }

    public void initialize(@Nonnull BootstrapRegistry registry) {
        if (Fabric8ConfigServerBootstrapper.hasConfigServerInstanceProvider()) {
            return;
        }
        registry.registerIfAbsent(KubernetesDiscoveryProperties.class, context -> {
            if (!Fabric8ConfigServerBootstrapper.getDiscoveryEnabled((BootstrapContext)context).booleanValue()) {
                return null;
            }
            return Fabric8ConfigServerBootstrapper.createKubernetesDiscoveryProperties((BootstrapContext)context);
        });
        registry.registerIfAbsent(KubernetesClientProperties.class, context -> {
            if (!Fabric8ConfigServerBootstrapper.getDiscoveryEnabled((BootstrapContext)context).booleanValue()) {
                return null;
            }
            return Fabric8ConfigServerBootstrapper.createKubernetesClientProperties((BootstrapContext)context);
        });
        registry.registerIfAbsent(ConfigServerInstanceProvider.Function.class, context -> {
            if (!Fabric8ConfigServerBootstrapper.getDiscoveryEnabled((BootstrapContext)context).booleanValue()) {
                return id -> Collections.emptyList();
            }
            if (context.isRegistered(Fabric8DiscoveryClient.class)) {
                Fabric8DiscoveryClient client = (Fabric8DiscoveryClient)context.get(Fabric8DiscoveryClient.class);
                return client::getInstances;
            }
            ConfigServerConfigDataLocationResolver.PropertyResolver propertyResolver = Fabric8ConfigServerBootstrapper.getPropertyResolver((BootstrapContext)context);
            Fabric8AutoConfiguration fabric8AutoConfiguration = new Fabric8AutoConfiguration();
            Config config = fabric8AutoConfiguration.kubernetesClientConfig((KubernetesClientProperties)context.get(KubernetesClientProperties.class));
            KubernetesClient kubernetesClient = fabric8AutoConfiguration.kubernetesClient(config);
            KubernetesDiscoveryProperties discoveryProperties = (KubernetesDiscoveryProperties)context.get(KubernetesDiscoveryProperties.class);
            Fabric8DiscoveryClient discoveryClient = new Fabric8DiscoveryClient(kubernetesClient, discoveryProperties, new ServicePortSecureResolver(discoveryProperties), new KubernetesNamespaceProvider((String)propertyResolver.get("spring.cloud.kubernetes.client.namespace", String.class, null)), new Fabric8DiscoveryClientSpelAutoConfiguration().predicate(discoveryProperties));
            return discoveryClient::getInstances;
        });
    }
}

