/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterNested;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.fabric8.Fabric8Utils;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

final class Fabric8KubernetesDiscoveryClientUtils {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(Fabric8KubernetesDiscoveryClientUtils.class));
    static final Predicate<Service> ALWAYS_TRUE = x -> true;

    private Fabric8KubernetesDiscoveryClientUtils() {
    }

    static List<Endpoints> endpoints(KubernetesDiscoveryProperties properties, KubernetesClient client, KubernetesNamespaceProvider namespaceProvider, String target, @Nullable String serviceName, Predicate<Service> filter) {
        List<Endpoints> endpoints;
        if (!properties.namespaces().isEmpty()) {
            LOG.debug(() -> "discovering endpoints in namespaces : " + properties.namespaces());
            ArrayList<Endpoints> inner = new ArrayList<Endpoints>(properties.namespaces().size());
            properties.namespaces().forEach(namespace -> inner.addAll(Fabric8KubernetesDiscoveryClientUtils.filteredEndpoints((FilterNested<FilterWatchListDeletable<Endpoints, EndpointsList, Resource<Endpoints>>>)((NonNamespaceOperation)client.endpoints().inNamespace(namespace)).withNewFilter(), properties, serviceName)));
            endpoints = inner;
        } else if (properties.allNamespaces()) {
            LOG.debug(() -> "discovering endpoints in all namespaces");
            endpoints = Fabric8KubernetesDiscoveryClientUtils.filteredEndpoints((FilterNested<FilterWatchListDeletable<Endpoints, EndpointsList, Resource<Endpoints>>>)((AnyNamespaceOperation)client.endpoints().inAnyNamespace()).withNewFilter(), properties, serviceName);
        } else {
            String namespace2 = Fabric8Utils.getApplicationNamespace((KubernetesClient)client, null, (String)target, (KubernetesNamespaceProvider)namespaceProvider);
            LOG.debug(() -> "discovering endpoints in namespace : " + namespace2);
            endpoints = Fabric8KubernetesDiscoveryClientUtils.filteredEndpoints((FilterNested<FilterWatchListDeletable<Endpoints, EndpointsList, Resource<Endpoints>>>)((NonNamespaceOperation)client.endpoints().inNamespace(namespace2)).withNewFilter(), properties, serviceName);
        }
        return Fabric8KubernetesDiscoveryClientUtils.withFilter(endpoints, properties, client, filter);
    }

    static List<Endpoints> withFilter(List<Endpoints> endpoints, KubernetesDiscoveryProperties properties, KubernetesClient client, Predicate<Service> filter) {
        if (properties.filter() == null || properties.filter().isBlank() || filter == ALWAYS_TRUE) {
            LOG.debug(() -> "filter not present");
            return endpoints;
        }
        ArrayList<Endpoints> result = new ArrayList<Endpoints>();
        Map<String, List<Endpoints>> endpointsByNamespace = endpoints.stream().collect(Collectors.groupingBy(x -> x.getMetadata().getNamespace()));
        for (Map.Entry<String, List<Endpoints>> entry : endpointsByNamespace.entrySet()) {
            Set filteredServiceNames = ((ServiceList)((NonNamespaceOperation)client.services().inNamespace(entry.getKey())).list()).getItems().stream().filter(filter).map(service -> service.getMetadata().getName()).collect(Collectors.toSet());
            result.addAll(entry.getValue().stream().filter(endpoint -> filteredServiceNames.contains(endpoint.getMetadata().getName())).toList());
        }
        return result;
    }

    static List<Endpoints> filteredEndpoints(FilterNested<FilterWatchListDeletable<Endpoints, EndpointsList, Resource<Endpoints>>> filterNested, KubernetesDiscoveryProperties properties, @Nullable String serviceName) {
        FilterNested partial = (FilterNested)filterNested.withLabels(properties.serviceLabels());
        if (serviceName != null) {
            partial = (FilterNested)partial.withField("metadata.name", serviceName);
        }
        return ((EndpointsList)((FilterWatchListDeletable)partial.endFilter()).list()).getItems();
    }

    static List<EndpointAddress> addresses(EndpointSubset endpointSubset, KubernetesDiscoveryProperties properties) {
        List addresses = Optional.ofNullable(endpointSubset.getAddresses()).map(ArrayList::new).orElse(new ArrayList());
        if (properties.includeNotReadyAddresses()) {
            List notReadyAddresses = endpointSubset.getNotReadyAddresses();
            if (CollectionUtils.isEmpty((Collection)notReadyAddresses)) {
                return addresses;
            }
            addresses.addAll(notReadyAddresses);
        }
        return addresses;
    }

    static List<Service> services(KubernetesDiscoveryProperties properties, KubernetesClient client, KubernetesNamespaceProvider namespaceProvider, Predicate<Service> predicate, Map<String, String> fieldFilters, String target) {
        List<Service> services;
        if (properties.allNamespaces()) {
            LOG.debug(() -> "discovering services in all namespaces");
            services = Fabric8KubernetesDiscoveryClientUtils.filteredServices((FilterNested<FilterWatchListDeletable<Service, ServiceList, ServiceResource<Service>>>)((AnyNamespaceOperation)client.services().inAnyNamespace()).withNewFilter(), properties, predicate, fieldFilters);
        } else if (!properties.namespaces().isEmpty()) {
            LOG.debug(() -> "discovering services in namespaces : " + properties.namespaces());
            ArrayList<Service> inner = new ArrayList<Service>(properties.namespaces().size());
            properties.namespaces().forEach(namespace -> inner.addAll(Fabric8KubernetesDiscoveryClientUtils.filteredServices((FilterNested<FilterWatchListDeletable<Service, ServiceList, ServiceResource<Service>>>)((NonNamespaceOperation)client.services().inNamespace(namespace)).withNewFilter(), properties, predicate, fieldFilters)));
            services = inner;
        } else {
            String namespace2 = Fabric8Utils.getApplicationNamespace((KubernetesClient)client, null, (String)target, (KubernetesNamespaceProvider)namespaceProvider);
            LOG.debug(() -> "discovering services in namespace : " + namespace2);
            services = Fabric8KubernetesDiscoveryClientUtils.filteredServices((FilterNested<FilterWatchListDeletable<Service, ServiceList, ServiceResource<Service>>>)((NonNamespaceOperation)client.services().inNamespace(namespace2)).withNewFilter(), properties, predicate, fieldFilters);
        }
        return services;
    }

    static Map<String, Integer> endpointSubsetsPortData(List<EndpointSubset> endpointSubsets) {
        return endpointSubsets.stream().flatMap(endpointSubset -> endpointSubset.getPorts().stream()).collect(Collectors.toMap(endpointPort -> StringUtils.hasText((String)endpointPort.getName()) ? endpointPort.getName() : "<unset>", EndpointPort::getPort));
    }

    private static List<Service> filteredServices(FilterNested<FilterWatchListDeletable<Service, ServiceList, ServiceResource<Service>>> filterNested, KubernetesDiscoveryProperties properties, Predicate<Service> predicate, @Nullable Map<String, String> fieldFilters) {
        FilterNested partial = (FilterNested)filterNested.withLabels(properties.serviceLabels());
        if (fieldFilters != null) {
            partial = (FilterNested)partial.withFields(fieldFilters);
        }
        return ((ServiceList)((FilterWatchListDeletable)partial.endFilter()).list()).getItems().stream().filter(predicate).toList();
    }
}

