/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery.reactive;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.fabric8.discovery.KubernetesClientServicesFunction;
import org.springframework.cloud.kubernetes.fabric8.discovery.KubernetesDiscoveryClient;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class KubernetesReactiveDiscoveryClient
implements ReactiveDiscoveryClient {
    private final KubernetesDiscoveryClient kubernetesDiscoveryClient;

    public KubernetesReactiveDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties properties, KubernetesClientServicesFunction kubernetesClientServicesFunction) {
        this.kubernetesDiscoveryClient = new KubernetesDiscoveryClient(client, properties, kubernetesClientServicesFunction);
    }

    public String description() {
        return "Kubernetes Reactive Discovery Client";
    }

    public Flux<ServiceInstance> getInstances(String serviceId) {
        Assert.notNull((Object)serviceId, (String)"[Assertion failed] - the object argument must not be null");
        return Flux.defer(() -> Flux.fromIterable(this.kubernetesDiscoveryClient.getInstances(serviceId))).subscribeOn(Schedulers.boundedElastic());
    }

    public Flux<String> getServices() {
        return Flux.defer(() -> Flux.fromIterable(this.kubernetesDiscoveryClient.getServices())).subscribeOn(Schedulers.boundedElastic());
    }
}

