/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.boot.bootstrap.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigDataRetryableConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.ConfigDataRetryableSecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.SecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.configdata.ConfigDataPropertiesHolder;
import org.springframework.cloud.kubernetes.commons.configdata.KubernetesConfigDataLocationResolver;
import org.springframework.cloud.kubernetes.fabric8.Fabric8AutoConfiguration;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SecretsPropertySourceLocator;

public class Fabric8ConfigDataLocationResolver
extends KubernetesConfigDataLocationResolver {
    protected void registerBeans(ConfigDataLocationResolverContext resolverContext, ConfigDataPropertiesHolder propertiesHolder, KubernetesNamespaceProvider namespaceProvider) {
        KubernetesClientProperties kubernetesClientProperties = propertiesHolder.clientProperties();
        ConfigMapConfigProperties configMapProperties = propertiesHolder.configMapProperties();
        SecretsConfigProperties secretsProperties = propertiesHolder.secretsProperties();
        ConfigurableBootstrapContext bootstrapContext = resolverContext.getBootstrapContext();
        KubernetesClient kubernetesClient = this.registerConfigAndClient(bootstrapContext, kubernetesClientProperties);
        if (configMapProperties != null && configMapProperties.enabled()) {
            Fabric8ConfigMapPropertySourceLocator configMapPropertySourceLocator = new Fabric8ConfigMapPropertySourceLocator(kubernetesClient, configMapProperties, namespaceProvider);
            if (this.isRetryEnabledForConfigMap(configMapProperties)) {
                configMapPropertySourceLocator = new ConfigDataRetryableConfigMapPropertySourceLocator((ConfigMapPropertySourceLocator)configMapPropertySourceLocator, configMapProperties);
            }
            ConfigUtils.registerSingle((ConfigurableBootstrapContext)bootstrapContext, ConfigMapPropertySourceLocator.class, (Object)((Object)configMapPropertySourceLocator), (String)"configDataConfigMapPropertySourceLocator");
        }
        if (secretsProperties != null && secretsProperties.enabled()) {
            Fabric8SecretsPropertySourceLocator secretsPropertySourceLocator = new Fabric8SecretsPropertySourceLocator(kubernetesClient, secretsProperties, namespaceProvider);
            if (this.isRetryEnabledForSecrets(secretsProperties)) {
                secretsPropertySourceLocator = new ConfigDataRetryableSecretsPropertySourceLocator((SecretsPropertySourceLocator)secretsPropertySourceLocator, secretsProperties);
            }
            ConfigUtils.registerSingle((ConfigurableBootstrapContext)bootstrapContext, SecretsPropertySourceLocator.class, (Object)((Object)secretsPropertySourceLocator), (String)"configDataSecretsPropertySourceLocator");
        }
    }

    private KubernetesClient registerConfigAndClient(ConfigurableBootstrapContext bootstrapContext, KubernetesClientProperties kubernetesClientProperties) {
        Config config = new Fabric8AutoConfiguration().kubernetesClientConfig(kubernetesClientProperties);
        ConfigUtils.registerSingle((ConfigurableBootstrapContext)bootstrapContext, Config.class, (Object)config, (String)"fabric8Config");
        KubernetesClient kubernetesClient = new Fabric8AutoConfiguration().kubernetesClient(config);
        ConfigUtils.registerSingle((ConfigurableBootstrapContext)bootstrapContext, KubernetesClient.class, (Object)kubernetesClient, (String)"configKubernetesClient", event -> kubernetesClient.close());
        return kubernetesClient;
    }
}

