/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.StrippedSourceContainer;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigUtils;
import org.springframework.core.log.LogAccessor;

final class Fabric8SourcesSingleRead {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(Fabric8SourcesSingleRead.class));

    private Fabric8SourcesSingleRead() {
    }

    static List<StrippedSourceContainer> strippedConfigMaps(KubernetesClient client, String namespace, LinkedHashSet<String> sourceNames) {
        ArrayList<ConfigMap> configMaps = new ArrayList<ConfigMap>(sourceNames.size());
        for (String sourceName : sourceNames) {
            ConfigMap configMap = (ConfigMap)((Resource)((NonNamespaceOperation)client.configMaps().inNamespace(namespace)).withName(sourceName)).get();
            if (configMap == null) continue;
            LOG.debug(() -> "Loaded config map '" + sourceName + "'");
            configMaps.add(configMap);
        }
        List<StrippedSourceContainer> strippedConfigMaps = Fabric8ConfigUtils.stripConfigMaps(configMaps);
        if (strippedConfigMaps.isEmpty()) {
            LOG.debug(() -> "No configmaps in namespace '" + namespace + "'");
        }
        return strippedConfigMaps;
    }

    static List<StrippedSourceContainer> strippedSecrets(KubernetesClient client, String namespace, LinkedHashSet<String> sourceNames) {
        ArrayList<Secret> secrets = new ArrayList<Secret>(sourceNames.size());
        for (String sourceName : sourceNames) {
            Secret secret = (Secret)((Resource)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withName(sourceName)).get();
            if (secret == null) continue;
            LOG.debug(() -> "Loaded config map '" + sourceName + "'");
            secrets.add(secret);
        }
        List<StrippedSourceContainer> strippedSecrets = Fabric8ConfigUtils.stripSecrets(secrets);
        if (strippedSecrets.isEmpty()) {
            LOG.debug(() -> "No secrets in namespace '" + namespace + "'");
        }
        return strippedSecrets;
    }

    static List<StrippedSourceContainer> strippedConfigMaps(KubernetesClient client, String namespace, Map<String, String> labels) {
        List configMaps = ((ConfigMapList)((FilterWatchListDeletable)((NonNamespaceOperation)client.configMaps().inNamespace(namespace)).withLabels(labels)).list()).getItems();
        for (ConfigMap configMap : configMaps) {
            LOG.debug(() -> "Loaded config map '" + configMap.getMetadata().getName() + "'");
        }
        List<StrippedSourceContainer> strippedConfigMaps = Fabric8ConfigUtils.stripConfigMaps(configMaps);
        if (strippedConfigMaps.isEmpty()) {
            LOG.debug(() -> "No configmaps in namespace '" + namespace + "'");
        }
        return strippedConfigMaps;
    }

    static List<StrippedSourceContainer> strippedSecrets(KubernetesClient client, String namespace, Map<String, String> labels) {
        List secrets = ((SecretList)((FilterWatchListDeletable)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withLabels(labels)).list()).getItems();
        for (Secret secret : secrets) {
            LOG.debug(() -> "Loaded secret '" + secret.getMetadata().getName() + "'");
        }
        List<StrippedSourceContainer> strippedSecrets = Fabric8ConfigUtils.stripSecrets(secrets);
        if (strippedSecrets.isEmpty()) {
            LOG.debug(() -> "No secrets in namespace '" + namespace + "'");
        }
        return strippedSecrets;
    }
}

