/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapPropertySource;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class Fabric8ConfigMapPropertySource
extends ConfigMapPropertySource {
    private static final Log LOG = LogFactory.getLog(Fabric8ConfigMapPropertySource.class);

    @Deprecated
    public Fabric8ConfigMapPropertySource(KubernetesClient client, String name) {
        this(client, name, null, null, "", true, false);
    }

    @Deprecated
    public Fabric8ConfigMapPropertySource(KubernetesClient client, String name, String namespace, Environment environment) {
        super(Fabric8ConfigMapPropertySource.getName((String)name, (String)Fabric8ConfigUtils.getApplicationNamespace(client, namespace, "Config Map", null)), Fabric8ConfigMapPropertySource.getData(client, name, Fabric8ConfigUtils.getApplicationNamespace(client, namespace, "Config Map", null), environment, "", true, false));
    }

    public Fabric8ConfigMapPropertySource(KubernetesClient client, String name, String namespace, Environment environment, String prefix, boolean includeProfileSpecificSources, boolean failFast) {
        super(Fabric8ConfigMapPropertySource.getName((String)name, (String)Fabric8ConfigUtils.getApplicationNamespace(client, namespace, "Config Map", null)), Fabric8ConfigMapPropertySource.getData(client, name, Fabric8ConfigUtils.getApplicationNamespace(client, namespace, "Config Map", null), environment, prefix, includeProfileSpecificSources, failFast));
    }

    private static Map<String, Object> getData(KubernetesClient client, String name, String namespace, Environment environment, String prefix, boolean includeProfileSpecificSources, boolean failFast) {
        LOG.debug((Object)("Loading ConfigMap with name '" + name + "' in namespace '" + namespace + "'"));
        try {
            Map<String, String> data = Fabric8ConfigUtils.getConfigMapData(client, namespace, name);
            HashMap<String, Object> result = new HashMap<String, Object>(Fabric8ConfigMapPropertySource.processAllEntries(data, (Environment)environment));
            if (environment != null && includeProfileSpecificSources) {
                for (String activeProfile : environment.getActiveProfiles()) {
                    String mapNameWithProfile = name + "-" + activeProfile;
                    Map<String, String> dataWithProfile = Fabric8ConfigUtils.getConfigMapData(client, namespace, mapNameWithProfile);
                    result.putAll(Fabric8ConfigMapPropertySource.processAllEntries(dataWithProfile, (Environment)environment));
                }
            }
            if (!"".equals(prefix)) {
                HashMap withPrefix = CollectionUtils.newHashMap((int)result.size());
                result.forEach((key, value) -> withPrefix.put(prefix + "." + key, value));
                return withPrefix;
            }
            return result;
        }
        catch (Exception e) {
            if (failFast) {
                throw new IllegalStateException("Unable to read ConfigMap with name '" + name + "' in namespace '" + namespace + "'", e);
            }
            LOG.warn((Object)("Can't read configMap with name: [" + name + "] in namespace: [" + namespace + "]. Ignoring."), (Throwable)e);
            return Collections.emptyMap();
        }
    }
}

