/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.SecretsPropertySource;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class Fabric8SecretsPropertySource
extends SecretsPropertySource {
    private static final Log LOG = LogFactory.getLog(Fabric8SecretsPropertySource.class);
    private static final String PREFIX = "secrets";

    public Fabric8SecretsPropertySource(KubernetesClient client, Environment env, String name, String namespace, Map<String, String> labels) {
        super(Fabric8SecretsPropertySource.getSourceName((String)name, (String)namespace), Fabric8SecretsPropertySource.getSourceData(client, env, name, namespace, labels));
    }

    private static Map<String, Object> getSourceData(KubernetesClient client, Environment env, String name, String namespace, Map<String, String> labels) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Secret secret = StringUtils.isEmpty((Object)namespace) ? (Secret)((Resource)client.secrets().withName(name)).get() : (Secret)((Resource)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withName(name)).get();
            Fabric8SecretsPropertySource.putAll(secret, result);
            if (!labels.isEmpty()) {
                if (StringUtils.isEmpty((Object)namespace)) {
                    ((SecretList)((FilterWatchListDeletable)client.secrets().withLabels(labels)).list()).getItems().forEach(s -> Fabric8SecretsPropertySource.putAll(s, result));
                } else {
                    ((SecretList)((FilterWatchListDeletable)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withLabels(labels)).list()).getItems().forEach(s -> Fabric8SecretsPropertySource.putAll(s, result));
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Can't read secret with name: [" + name + "] or labels [" + labels + "] in namespace:[" + namespace + "] (cause: " + e.getMessage() + "). Ignoring"));
        }
        return result;
    }

    private static void putAll(Secret secret, Map<String, Object> result) {
        if (secret != null) {
            Fabric8SecretsPropertySource.putAll((Map)secret.getData(), result);
        }
    }
}

