/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodStatus;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.kubernetes.commons.AbstractKubernetesHealthIndicator;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.util.CollectionUtils;

final class Fabric8HealthIndicator
extends AbstractKubernetesHealthIndicator {
    private final PodUtils<Pod> utils;

    Fabric8HealthIndicator(PodUtils<Pod> utils) {
        this.utils = utils;
    }

    protected Map<String, Object> getDetails() {
        Pod current = (Pod)this.utils.currentPod().get();
        if (current != null) {
            HashMap details = CollectionUtils.newHashMap((int)8);
            details.put("inside", true);
            ObjectMeta metadata = current.getMetadata();
            details.put("namespace", metadata.getNamespace());
            details.put("podName", metadata.getName());
            details.put("labels", metadata.getLabels());
            PodStatus status = current.getStatus();
            details.put("podIp", status.getPodIP());
            details.put("hostIp", status.getHostIP());
            PodSpec spec = current.getSpec();
            details.put("serviceAccount", spec.getServiceAccountName());
            details.put("nodeName", spec.getNodeName());
            return details;
        }
        return Collections.singletonMap("inside", false);
    }
}

