/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.nio.file.Paths;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.EnvReader;
import org.springframework.cloud.kubernetes.commons.LazilyInstantiate;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.util.StringUtils;

public class Fabric8PodUtils
implements PodUtils<Pod> {
    public static final String HOSTNAME = "HOSTNAME";
    public static final String KUBERNETES_SERVICE_HOST = "KUBERNETES_SERVICE_HOST";
    private static final Log LOG = LogFactory.getLog(Fabric8PodUtils.class);
    private final KubernetesClient client;
    private final String hostName;
    private final String serviceHost;
    private final Supplier<Pod> current;

    public Fabric8PodUtils(KubernetesClient client) {
        if (client == null) {
            throw new IllegalArgumentException("Must provide an instance of KubernetesClient");
        }
        this.client = client;
        this.hostName = EnvReader.getEnv((String)HOSTNAME);
        this.serviceHost = EnvReader.getEnv((String)KUBERNETES_SERVICE_HOST);
        this.current = LazilyInstantiate.using(this::internalGetPod);
    }

    public Supplier<Pod> currentPod() {
        return this.current;
    }

    public boolean isInsideKubernetes() {
        return this.currentPod().get() != null;
    }

    private Pod internalGetPod() {
        try {
            if (this.isServiceHostEnvVarPresent() && this.isHostNameEnvVarPresent() && this.isServiceAccountFound()) {
                return (Pod)((PodResource)this.client.pods().withName(this.hostName)).get();
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)("Failed to get pod with name:[" + this.hostName + "]. You should look into this if things aren't working as you expect. Are you missing serviceaccount permissions?"), t);
        }
        return null;
    }

    private boolean isServiceHostEnvVarPresent() {
        return StringUtils.hasLength((String)this.serviceHost);
    }

    private boolean isHostNameEnvVarPresent() {
        return StringUtils.hasLength((String)this.hostName);
    }

    private boolean isServiceAccountFound() {
        boolean serviceAccountPathPresent = Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/token", new String[0]).toFile().exists();
        if (!serviceAccountPathPresent) {
            LOG.warn((Object)"serviceaccount path not present, did you disable it via 'automountServiceAccountToken : false'? Major functionalities will not work without that property being set");
        }
        return serviceAccountPathPresent && Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt", new String[0]).toFile().exists();
    }
}

