/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discoveryserver;

import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.kubernetes.client.discovery.reactive.KubernetesInformerReactiveDiscoveryClient;
import org.springframework.cloud.kubernetes.commons.discovery.DefaultKubernetesServiceInstance;
import org.springframework.cloud.kubernetes.commons.discovery.Service;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
public class DiscoveryServerController {
    private final KubernetesInformerReactiveDiscoveryClient reactiveDiscoveryClient;

    public DiscoveryServerController(KubernetesInformerReactiveDiscoveryClient reactiveDiscoveryClient) {
        this.reactiveDiscoveryClient = reactiveDiscoveryClient;
    }

    @GetMapping(value={"/apps"})
    public Flux<Service> apps() {
        return this.reactiveDiscoveryClient.getServices().flatMap(service -> this.reactiveDiscoveryClient.getInstances(service).collectList().flatMap(serviceInstances -> Mono.just((Object)new Service(service, serviceInstances.stream().map(x -> (DefaultKubernetesServiceInstance)x).toList()))));
    }

    @GetMapping(value={"/apps/{name}"})
    public Flux<ServiceInstance> appInstances(@PathVariable String name) {
        return this.reactiveDiscoveryClient.getInstances(name);
    }

    @GetMapping(value={"/app/{name}/{instanceId}"})
    public Mono<ServiceInstance> appInstance(@PathVariable String name, @PathVariable String instanceId) {
        return this.reactiveDiscoveryClient.getInstances(name).filter(serviceInstance -> serviceInstance.getInstanceId().equals(instanceId)).singleOrEmpty();
    }
}

