/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import java.util.List;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.discovery.KubernetesAbstractBlockingDiscoveryClient;
import org.springframework.web.client.RestTemplate;

class KubernetesCacheableDiscoveryClient
extends KubernetesAbstractBlockingDiscoveryClient {
    KubernetesCacheableDiscoveryClient(RestTemplate rest, KubernetesDiscoveryProperties kubernetesDiscoveryProperties) {
        super(rest, kubernetesDiscoveryProperties);
    }

    @Override
    @Cacheable(value={"k8s-blocking-discovery-services"})
    public List<String> getServices() {
        return super.getServices();
    }

    @Override
    @Cacheable(value={"k8s-blocking-discovery-instances"})
    public List<ServiceInstance> getInstances(String serviceId) {
        return super.getInstances(serviceId);
    }

    @Override
    public String description() {
        return "Kubernetes Cacheable Discovery Client";
    }
}

