/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.CommonsClientAutoConfiguration;
import org.springframework.cloud.client.ConditionalOnBlockingDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryHealthIndicatorEnabled;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClientAutoConfiguration;
import org.springframework.cloud.kubernetes.ConditionalOnKubernetesEnabled;
import org.springframework.cloud.kubernetes.KubernetesAutoConfiguration;
import org.springframework.cloud.kubernetes.PodUtils;
import org.springframework.cloud.kubernetes.discovery.ConditionalOnKubernetesDiscoveryEnabled;
import org.springframework.cloud.kubernetes.discovery.DefaultIsServicePortSecureResolver;
import org.springframework.cloud.kubernetes.discovery.KubernetesClientServicesFunction;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryClient;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryClientHealthIndicatorInitializer;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.registry.KubernetesRegistration;
import org.springframework.cloud.kubernetes.registry.KubernetesServiceRegistry;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
@ConditionalOnKubernetesEnabled
@AutoConfigureBefore(value={SimpleDiscoveryClientAutoConfiguration.class, CommonsClientAutoConfiguration.class})
@AutoConfigureAfter(value={KubernetesAutoConfiguration.class})
public class KubernetesDiscoveryClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public DefaultIsServicePortSecureResolver isServicePortSecureResolver(KubernetesDiscoveryProperties properties) {
        return new DefaultIsServicePortSecureResolver(properties);
    }

    @Bean
    public KubernetesClientServicesFunction servicesFunction(KubernetesDiscoveryProperties properties) {
        if (properties.getServiceLabels().isEmpty()) {
            if (properties.isAllNamespaces()) {
                return client -> (FilterWatchListMultiDeletable)client.services().inAnyNamespace();
            }
            return KubernetesClient::services;
        }
        if (properties.isAllNamespaces()) {
            return client -> (FilterWatchListDeletable)((FilterWatchListMultiDeletable)client.services().inAnyNamespace()).withLabels(properties.getServiceLabels());
        }
        return client -> (FilterWatchListDeletable)client.services().withLabels(properties.getServiceLabels());
    }

    @Bean
    public KubernetesServiceRegistry getServiceRegistry() {
        return new KubernetesServiceRegistry();
    }

    @Bean
    public KubernetesRegistration getRegistration(KubernetesClient client, KubernetesDiscoveryProperties properties) {
        return new KubernetesRegistration(client, properties);
    }

    @Bean
    public KubernetesDiscoveryProperties getKubernetesDiscoveryProperties() {
        return new KubernetesDiscoveryProperties();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBlockingDiscoveryEnabled
    @ConditionalOnKubernetesDiscoveryEnabled
    public static class KubernetesDiscoveryClientConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public KubernetesDiscoveryClient kubernetesDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties properties, KubernetesClientServicesFunction kubernetesClientServicesFunction, DefaultIsServicePortSecureResolver isServicePortSecureResolver) {
            return new KubernetesDiscoveryClient(client, properties, kubernetesClientServicesFunction, isServicePortSecureResolver);
        }
    }

    @ConditionalOnClass(value={HealthIndicator.class})
    @ConditionalOnDiscoveryEnabled
    @ConditionalOnDiscoveryHealthIndicatorEnabled
    @Configuration
    public static class KubernetesDiscoveryClientHealthIndicatorConfiguration {
        @Bean
        public KubernetesDiscoveryClientHealthIndicatorInitializer indicatorInitializer(ApplicationEventPublisher applicationEventPublisher, PodUtils podUtils) {
            return new KubernetesDiscoveryClientHealthIndicatorInitializer(podUtils, applicationEventPublisher);
        }
    }
}

