/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.kubernetes.discovery.DefaultIsServicePortSecureResolver;
import org.springframework.cloud.kubernetes.discovery.EndpointSubsetNS;
import org.springframework.cloud.kubernetes.discovery.KubernetesClientServicesFunction;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.discovery.KubernetesServiceInstance;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class KubernetesDiscoveryClient
implements DiscoveryClient {
    private static final Log log = LogFactory.getLog(KubernetesDiscoveryClient.class);
    private final KubernetesDiscoveryProperties properties;
    private final DefaultIsServicePortSecureResolver isServicePortSecureResolver;
    private final KubernetesClientServicesFunction kubernetesClientServicesFunction;
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private final SimpleEvaluationContext evalCtxt = SimpleEvaluationContext.forReadOnlyDataBinding().withInstanceMethods().build();
    private KubernetesClient client;

    public KubernetesDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties kubernetesDiscoveryProperties, KubernetesClientServicesFunction kubernetesClientServicesFunction) {
        this(client, kubernetesDiscoveryProperties, kubernetesClientServicesFunction, new DefaultIsServicePortSecureResolver(kubernetesDiscoveryProperties));
    }

    KubernetesDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties kubernetesDiscoveryProperties, KubernetesClientServicesFunction kubernetesClientServicesFunction, DefaultIsServicePortSecureResolver isServicePortSecureResolver) {
        this.client = client;
        this.properties = kubernetesDiscoveryProperties;
        this.kubernetesClientServicesFunction = kubernetesClientServicesFunction;
        this.isServicePortSecureResolver = isServicePortSecureResolver;
    }

    public KubernetesClient getClient() {
        return this.client;
    }

    public void setClient(KubernetesClient client) {
        this.client = client;
    }

    public String description() {
        return "Kubernetes Discovery Client";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        Assert.notNull((Object)serviceId, (String)"[Assertion failed] - the object argument must not be null");
        List endpointsList = this.properties.isAllNamespaces() ? ((EndpointsList)((FilterWatchListDeletable)((FilterWatchListMultiDeletable)this.client.endpoints().inAnyNamespace()).withField("metadata.name", serviceId)).list()).getItems() : Collections.singletonList(((Resource)this.client.endpoints().withName(serviceId)).get());
        List subsetsNS = endpointsList.stream().map(endpoints -> this.getSubsetsFromEndpoints((Endpoints)endpoints)).collect(Collectors.toList());
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        if (!subsetsNS.isEmpty()) {
            for (EndpointSubsetNS es : subsetsNS) {
                instances.addAll(this.getNamespaceServiceInstances(es, serviceId));
            }
        }
        return instances;
    }

    private List<ServiceInstance> getNamespaceServiceInstances(EndpointSubsetNS es, String serviceId) {
        String namespace = es.getNamespace();
        List<EndpointSubset> subsets = es.getEndpointSubset();
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        if (!subsets.isEmpty()) {
            Service service = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).withName(serviceId)).get();
            Map<String, String> serviceMetadata = this.getServiceMetadata(service);
            KubernetesDiscoveryProperties.Metadata metadataProps = this.properties.getMetadata();
            for (EndpointSubset s : subsets) {
                HashMap<String, String> endpointMetadata = new HashMap<String, String>(serviceMetadata);
                if (metadataProps.isAddPorts()) {
                    Map<String, String> ports = s.getPorts().stream().filter(port -> !StringUtils.isEmpty((Object)port.getName())).collect(Collectors.toMap(EndpointPort::getName, port -> Integer.toString(port.getPort())));
                    Map<String, String> portMetadata = this.getMapWithPrefixedKeys(ports, metadataProps.getPortsPrefix());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding port metadata: " + portMetadata));
                    }
                    endpointMetadata.putAll(portMetadata);
                }
                List addresses = s.getAddresses();
                for (EndpointAddress endpointAddress : addresses) {
                    String instanceId = null;
                    if (endpointAddress.getTargetRef() != null) {
                        instanceId = endpointAddress.getTargetRef().getUid();
                    }
                    EndpointPort endpointPort = this.findEndpointPort(s);
                    instances.add(new KubernetesServiceInstance(instanceId, serviceId, endpointAddress, endpointPort, endpointMetadata, this.isServicePortSecureResolver.resolve(new DefaultIsServicePortSecureResolver.Input(endpointPort.getPort(), service.getMetadata().getName(), service.getMetadata().getLabels(), service.getMetadata().getAnnotations()))));
                }
            }
        }
        return instances;
    }

    private Map<String, String> getServiceMetadata(Service service) {
        HashMap<String, String> serviceMetadata = new HashMap<String, String>();
        KubernetesDiscoveryProperties.Metadata metadataProps = this.properties.getMetadata();
        if (metadataProps.isAddLabels()) {
            Map<String, String> labelMetadata = this.getMapWithPrefixedKeys(service.getMetadata().getLabels(), metadataProps.getLabelsPrefix());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding label metadata: " + labelMetadata));
            }
            serviceMetadata.putAll(labelMetadata);
        }
        if (metadataProps.isAddAnnotations()) {
            Map<String, String> annotationMetadata = this.getMapWithPrefixedKeys(service.getMetadata().getAnnotations(), metadataProps.getAnnotationsPrefix());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding annotation metadata: " + annotationMetadata));
            }
            serviceMetadata.putAll(annotationMetadata);
        }
        return serviceMetadata;
    }

    private EndpointPort findEndpointPort(EndpointSubset s) {
        EndpointPort endpointPort;
        List ports = s.getPorts();
        if (ports.size() == 1) {
            endpointPort = (EndpointPort)ports.get(0);
        } else {
            Predicate<EndpointPort> portPredicate = !StringUtils.isEmpty((Object)this.properties.getPrimaryPortName()) ? port -> this.properties.getPrimaryPortName().equalsIgnoreCase(port.getName()) : port -> true;
            endpointPort = ports.stream().filter(portPredicate).findAny().orElseThrow(IllegalStateException::new);
        }
        return endpointPort;
    }

    private EndpointSubsetNS getSubsetsFromEndpoints(Endpoints endpoints) {
        EndpointSubsetNS es = new EndpointSubsetNS();
        es.setNamespace(this.client.getNamespace());
        if (endpoints != null && endpoints.getSubsets() != null) {
            es.setNamespace(endpoints.getMetadata().getNamespace());
            es.setEndpointSubset(endpoints.getSubsets());
        }
        return es;
    }

    private Map<String, String> getMapWithPrefixedKeys(Map<String, String> map, String prefix) {
        if (map == null) {
            return new HashMap<String, String>();
        }
        if (!StringUtils.hasText((String)prefix)) {
            return map;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        map.forEach((k, v) -> result.put(prefix + k, (String)v));
        return result;
    }

    public List<String> getServices() {
        Predicate<Service> filteredServices;
        String spelExpression = this.properties.getFilter();
        if (spelExpression == null || spelExpression.isEmpty()) {
            filteredServices = instance -> true;
        } else {
            Expression filterExpr = this.parser.parseExpression(spelExpression);
            filteredServices = instance -> {
                Boolean include = (Boolean)filterExpr.getValue((EvaluationContext)this.evalCtxt, instance, Boolean.class);
                if (include == null) {
                    return false;
                }
                return include;
            };
        }
        return this.getServices(filteredServices);
    }

    public List<String> getServices(Predicate<Service> filter) {
        return ((ServiceList)((FilterWatchListDeletable)this.kubernetesClientServicesFunction.apply(this.client)).list()).getItems().stream().filter(filter).map(s -> s.getMetadata().getName()).collect(Collectors.toList());
    }

    public int getOrder() {
        return this.properties.getOrder();
    }
}

