/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointPort;
import java.net.URI;
import java.util.Map;
import org.springframework.cloud.client.ServiceInstance;

public class KubernetesServiceInstance
implements ServiceInstance {
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    private static final String COLN = ":";
    private final String instanceId;
    private final String serviceId;
    private final EndpointAddress endpointAddress;
    private final EndpointPort endpointPort;
    private final Boolean secure;
    private final Map<String, String> metadata;

    @Deprecated
    public KubernetesServiceInstance(String serviceId, EndpointAddress endpointAddress, EndpointPort endpointPort, Map<String, String> metadata, Boolean secure) {
        this(null, serviceId, endpointAddress, endpointPort, metadata, secure);
    }

    public KubernetesServiceInstance(String instanceId, String serviceId, EndpointAddress endpointAddress, EndpointPort endpointPort, Map<String, String> metadata, Boolean secure) {
        this.instanceId = instanceId;
        this.serviceId = serviceId;
        this.endpointAddress = endpointAddress;
        this.endpointPort = endpointPort;
        this.metadata = metadata;
        this.secure = secure;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getHost() {
        return this.endpointAddress.getIp();
    }

    public int getPort() {
        return this.endpointPort.getPort();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public URI getUri() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getScheme()).append(this.getHost()).append(COLN).append(this.getPort());
        return URI.create(sb.toString());
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getScheme() {
        return this.isSecure() ? HTTPS_PREFIX : HTTP_PREFIX;
    }
}

