/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configuration.watcher;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(value="spring.cloud.kubernetes.configuration.watcher")
public class ConfigurationWatcherConfigurationProperties {
    public static final String AMQP = "bus-amqp";
    public static final String KAFKA = "bus-kafka";
    static final String NOT_AMQP_NOT_KAFKA = "!bus-amqp & !bus-kafka";
    public static final String CONFIG_MAP_LABEL = "spring.cloud.kubernetes.config";
    public static final String SECRET_LABEL = "spring.cloud.kubernetes.secret";
    public static final String CONFIG_MAP_APPS_ANNOTATION = "spring.cloud.kubernetes.configmap.apps";
    public static final String SECRET_APPS_ANNOTATION = "spring.cloud.kubernetes.secret.apps";
    public static final String ANNOTATION_KEY = "boot.spring.io/actuator";
    @DurationUnit(value=ChronoUnit.MILLIS)
    private Duration refreshDelay = Duration.ofMillis(120000L);
    private RefreshStrategy refreshStrategy = RefreshStrategy.REFRESH;
    private int threadPoolSize = 1;
    private String actuatorPath = "/actuator";
    private Integer actuatorPort = -1;

    public String getActuatorPath() {
        return this.actuatorPath;
    }

    public void setActuatorPath(String actuatorPath) {
        Object normalizedPath = actuatorPath;
        if (!((String)normalizedPath).startsWith("/")) {
            normalizedPath = "/" + (String)normalizedPath;
        }
        if (((String)normalizedPath).endsWith("/")) {
            normalizedPath = ((String)normalizedPath).substring(0, ((String)normalizedPath).length() - 1);
        }
        this.actuatorPath = normalizedPath;
    }

    public Integer getActuatorPort() {
        return this.actuatorPort;
    }

    public void setActuatorPort(Integer actuatorPort) {
        this.actuatorPort = actuatorPort;
    }

    public Duration getRefreshDelay() {
        return this.refreshDelay;
    }

    public void setRefreshDelay(Duration refreshDelay) {
        this.refreshDelay = refreshDelay;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public RefreshStrategy getRefreshStrategy() {
        return this.refreshStrategy;
    }

    public void setRefreshStrategy(RefreshStrategy refreshStrategy) {
        this.refreshStrategy = refreshStrategy;
    }

    public static enum RefreshStrategy {
        REFRESH,
        SHUTDOWN;

    }
}

